/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.events.blocks;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.Events.CustomBlockInteractEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;

public class EvtCustomBlockInteract
extends SkriptEvent {
    private Literal<?>[] blockNames;
    private List<String> aliases;
    private AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.blockNames = args;
        if (this.blockNames != null) {
            this.aliases = Arrays.stream(this.blockNames).flatMap(literal -> {
                if (literal != null) {
                    return Arrays.stream(literal.getArray()).map(Util::getCustomBlockId);
                }
                return Stream.empty();
            }).filter(name -> name != null).collect(Collectors.toList());
        }
        return true;
    }

    public boolean check(Event event) {
        if (!(event instanceof CustomBlockInteractEvent)) {
            return false;
        }
        CustomBlockInteractEvent customEvent = (CustomBlockInteractEvent)event;
        if (customEvent.isCancelled()) {
            return false;
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            String actualBlockName = Util.getCustomBlockId(customEvent.getNamespacedID());
            return this.aliases.contains(actualBlockName);
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Custom Block Interact event";
    }

    static {
        Skript.registerEvent((String)"Custom Block Interact", EvtCustomBlockInteract.class, CustomBlockInteractEvent.class, (String[])new String[]{"interact with [custom] (ia|itemsadder) block[s] [%customitemtypes/strings%]"}).description(new String[]{"Fires when a ItemsAdder block gets interacted with."}).examples(new String[]{"on interact with itemsadder block:"}).since("1.0").requiredPlugins(new String[]{"ItemsAdder"});
        EventValues.registerEventValue(CustomBlockInteractEvent.class, CustomBlock.class, (Getter)new Getter<CustomBlock, CustomBlockInteractEvent>(){

            public CustomBlock get(CustomBlockInteractEvent event) {
                return CustomBlock.byAlreadyPlaced((Block)event.getBlockClicked());
            }
        }, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Location.class, (Getter)new Getter<Location, CustomBlockInteractEvent>(){

            public Location get(CustomBlockInteractEvent event) {
                return event.getBlockClicked().getLocation();
            }
        }, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Action.class, (Getter)new Getter<Action, CustomBlockInteractEvent>(){

            public Action get(CustomBlockInteractEvent customBlockInteractEvent) {
                return customBlockInteractEvent.getAction();
            }
        }, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, BlockFace.class, (Getter)new Getter<BlockFace, CustomBlockInteractEvent>(){

            public BlockFace get(CustomBlockInteractEvent customBlockInteractEvent) {
                return customBlockInteractEvent.getBlockFace();
            }
        }, (int)0);
    }
}

