/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.events.blocks;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class EvtCustomBlockBreak
extends SkriptEvent {
    private Literal<?>[] blockNames;
    private List<String> aliases;
    private AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.blockNames = args;
        if (this.blockNames != null) {
            this.aliases = Arrays.stream(this.blockNames).flatMap(literal -> {
                if (literal != null) {
                    return Arrays.stream(literal.getArray()).map(Util::getCustomBlockId);
                }
                return Stream.empty();
            }).filter(name -> name != null).collect(Collectors.toList());
        }
        return true;
    }

    public boolean check(Event event) {
        if (!(event instanceof CustomBlockBreakEvent)) {
            return false;
        }
        CustomBlockBreakEvent customEvent = (CustomBlockBreakEvent)event;
        if (customEvent.isCancelled()) {
            return false;
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            String actualBlockName = Util.getCustomBlockId(customEvent.getNamespacedID());
            return this.aliases.contains(actualBlockName);
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Custom Block Break event";
    }

    static {
        Skript.registerEvent((String)"Custom Block Break", EvtCustomBlockBreak.class, CustomBlockBreakEvent.class, (String[])new String[]{"break [of] [custom] (ia|itemsadder) block[s] [%customitemtypes/strings%]"}).description(new String[]{"Fires when a ItemsAdder block gets broken."}).examples(new String[]{"on break of itemsadder block \"namespace:ruby_block\":", "on break of itemsadder block ruby block:"}).since("1.0").requiredPlugins(new String[]{"ItemsAdder"});
        EventValues.registerEventValue(CustomBlockBreakEvent.class, CustomBlock.class, (Getter)new Getter<CustomBlock, CustomBlockBreakEvent>(){

            public CustomBlock get(CustomBlockBreakEvent event) {
                return CustomBlock.byAlreadyPlaced((Block)event.getBlock());
            }
        }, (int)0);
        EventValues.registerEventValue(CustomBlockBreakEvent.class, Location.class, (Getter)new Getter<Location, CustomBlockBreakEvent>(){

            public Location get(CustomBlockBreakEvent event) {
                return event.getBlock().getLocation();
            }
        }, (int)0);
    }
}

