/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects.furniture;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomFurniture;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Remove Custom Furniture")
@Description(value={"If there is furniture at a location, this effect will remove it."})
@Examples(value={"remove itemsadder furniture at player's location"})
@Since(value="1.4")
@RequiredPlugins(value={"ItemsAdder"})
public class EffRemoveCustomFurniture
extends Effect {
    private Expression<String> furnitureId;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.furnitureId = exprs[0];
        this.locations = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Location[] locs = (Location[])this.locations.getAll(e);
        ArrayList<String> customFurnitureIds = new ArrayList<String>();
        if (this.furnitureId != null) {
            if (this.furnitureId.isSingle()) {
                Object object = this.furnitureId.getSingle(e);
                customFurnitureIds.add(Util.getCustomBlockId(object));
            } else {
                for (String string : (String[])this.furnitureId.getArray(e)) {
                    customFurnitureIds.add(Util.getCustomBlockId(string));
                }
            }
        }
        for (Location location : locs) {
            for (String id : customFurnitureIds) {
                CustomFurniture existingFurniture;
                if (id == null || location == null || (existingFurniture = CustomFurniture.byAlreadySpawned((Block)location.getBlock())) == null) continue;
                existingFurniture.remove(false);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "remove custom furniture " + (this.furnitureId != null ? this.furnitureId.toString(e, debug) : "") + " at " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffRemoveCustomFurniture.class, (String[])new String[]{"(remove|delete) [custom] (ia|itemsadder) furniture [%customitemtypes/strings%] at %locations%"});
    }
}

