/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects.furniture;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomFurniture;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

@Name(value="Place Custom Furniture")
@Description(value={"Place a custom furniture at a location.", "If there is a furniture at the same location, this effect will replace it."})
@Examples(value={"place itemsadder furniture \"coolfurniture:comfy_chair\" at player's location"})
@Since(value="1.3, 1.6 (Replacing)")
@RequiredPlugins(value={"ItemsAdder"})
public class EffPlaceCustomFurniture
extends Effect {
    private Expression<?> furnitureIdExpr;
    private Expression<Location> locationExpr;
    private JavaPlugin plugin;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.furnitureIdExpr = exprs[0];
        this.locationExpr = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        if (this.furnitureIdExpr == null || this.locationExpr == null) {
            return;
        }
        ArrayList<String> furnitureIds = new ArrayList<String>();
        if (this.furnitureIdExpr.isSingle()) {
            Object[] itemType = this.furnitureIdExpr.getSingle(e);
            furnitureIds.add(Util.getCustomBlockId(itemType));
        } else {
            for (Object itemType : this.furnitureIdExpr.getArray(e)) {
                furnitureIds.add(Util.getCustomBlockId(itemType));
            }
        }
        Location location = (Location)this.locationExpr.getSingle(e);
        if (location == null) {
            return;
        }
        for (final String furnitureId : furnitureIds) {
            if (furnitureId == null) {
                Skript.error((String)"Invalid custom furniture ID.");
                continue;
            }
            CustomFurniture customFurniture = CustomFurniture.byAlreadySpawned((Block)location.getBlock());
            if (customFurniture == null) {
                CustomFurniture.spawn((String)furnitureId, (Block)location.getBlock());
                continue;
            }
            Entity armorStand = customFurniture.getArmorstand();
            if (armorStand == null) continue;
            final Location originalLocation = armorStand.getLocation();
            customFurniture.remove(false);
            new BukkitRunnable(){

                public void run() {
                    CustomFurniture.spawn((String)furnitureId, (Block)originalLocation.getBlock());
                }
            }.runTaskLater((Plugin)this.plugin, 3L);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "(set|place) [custom] (ia|itemsadder) furniture " + this.furnitureIdExpr.toString(e, debug) + " at " + this.locationExpr.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPlaceCustomFurniture.class, (String[])new String[]{"(set|place) [custom] (ia|itemsadder) furniture %customitemtypes/strings% at %location%"});
    }
}

