/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects.blocks;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Set Custom Blocks Within")
@Description(value={"Sets the blocks within 2 locations to ItemsAdder custom blocks."})
@Examples(value={"set all blocks within location(0, 100, 0) and player's location to itemsadder block \"iasurvival:ruby_block\""})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EffSetBlocksBetween
extends Effect {
    private Expression<Location> location1Expr;
    private Expression<Location> location2Expr;
    private Expression<?> customBlockIdExpr;
    private AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location1Expr = exprs[0];
        this.location2Expr = exprs[1];
        this.customBlockIdExpr = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        Location location1 = (Location)this.location1Expr.getSingle(e);
        Location location2 = (Location)this.location2Expr.getSingle(e);
        Object customBlockIdObj = this.customBlockIdExpr.getSingle(e);
        String customBlockId = Util.getCustomBlockId(customBlockIdObj);
        ArrayList<String> customBlockIds = new ArrayList<String>();
        if (this.customBlockIdExpr.isSingle()) {
            Object[] itemType = this.customBlockIdExpr.getSingle(e);
            customBlockIds.add(Util.getCustomBlockId(itemType));
        } else {
            for (Object itemType : this.customBlockIdExpr.getArray(e)) {
                customBlockIds.add(Util.getCustomBlockId(itemType));
            }
        }
        if (location1 == null || location2 == null || customBlockId == null) {
            return;
        }
        int minX = Math.min(location1.getBlockX(), location2.getBlockX());
        int minY = Math.min(location1.getBlockY(), location2.getBlockY());
        int minZ = Math.min(location1.getBlockZ(), location2.getBlockZ());
        int maxX = Math.max(location1.getBlockX(), location2.getBlockX());
        int maxY = Math.max(location1.getBlockY(), location2.getBlockY());
        int maxZ = Math.max(location1.getBlockZ(), location2.getBlockZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Location location = new Location(location1.getWorld(), (double)x, (double)y, (double)z);
                    CustomBlock customBlock = CustomBlock.getInstance((String)customBlockId);
                    if (customBlock == null) continue;
                    customBlock.place(location);
                }
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "place custom block " + this.customBlockIdExpr.toString(e, debug) + " between locations " + this.location1Expr.toString(e, debug) + " and " + this.location2Expr.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetBlocksBetween.class, (String[])new String[]{"(set|place) [all] blocks within %location% and %location% to [custom] (ia|itemsadder) block %customitemtypes/strings%"});
    }
}

