/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects.blocks;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Replace Custom Block")
@Description(value={"If there is a custom block at a location, this effect will remove it and place the one you specify."})
@Examples(value={"replace custom block \"diamond_tiles\" at player's location"})
@Since(value="1.4")
@RequiredPlugins(value={"ItemsAdder"})
public class EffReplaceBlock
extends Effect {
    private Expression<String> blockId;
    private Expression<Location> location;

    protected void execute(Event e) {
        String id = (String)this.blockId.getSingle(e);
        Location loc = (Location)this.location.getSingle(e);
        if (id != null && loc != null) {
            CustomBlock existingBlock = CustomBlock.byAlreadyPlaced((Block)loc.getBlock());
            if (existingBlock != null) {
                existingBlock.remove();
            }
            CustomBlock.place((String)id, (Location)loc);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "replace itemsadder block " + this.blockId.toString(e, debug) + " at " + this.location.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockId = exprs[0];
        this.location = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffReplaceBlock.class, (String[])new String[]{"replace [custom] (ia|itemsadder) block %string% at %location%"});
    }
}

