/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects.blocks;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomCrop;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Place Custom Block/Crop")
@Description(value={"Places a custom block or crop at a location."})
@Examples(value={"set block at player's location to itemsadder block \"iasurvival:ruby_block\"", "set block at player's location to custom itemsadder crop best seed"})
@Since(value="1.0, 1.5 (Placing Crops & Syntax rework)")
@RequiredPlugins(value={"ItemsAdder"})
public class EffPlaceBlockOrCrop
extends Effect {
    private Expression<Location> locations;
    private Expression<?> blockNames;
    private boolean isCrop;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.blockNames = exprs[0];
            this.locations = Direction.combine(exprs[1], exprs[2]);
        } else {
            this.blockNames = exprs[2];
            this.locations = Direction.combine(exprs[0], exprs[1]);
        }
        this.isCrop = parseResult.hasTag("crop");
        return true;
    }

    protected void execute(Event e) {
        if (this.locations == null || this.blockNames == null) {
            return;
        }
        ArrayList<String> customBlockIds = new ArrayList<String>();
        if (this.blockNames.isSingle()) {
            Object itemType = this.blockNames.getSingle(e);
            customBlockIds.add(Util.getCustomBlockId(itemType));
        } else {
            for (Object itemType : this.blockNames.getArray(e)) {
                customBlockIds.add(Util.getCustomBlockId(itemType));
            }
        }
        for (Location location : (Location[])this.locations.getArray(e)) {
            for (String customBlockId : customBlockIds) {
                if (customBlockId == null) {
                    Skript.error((String)"Invalid custom block ID.");
                    continue;
                }
                try {
                    CustomBlock block;
                    if (this.isCrop) {
                        CustomCrop.place((String)customBlockId, (Location)location);
                        continue;
                    }
                    CustomBlock existingBlock = CustomBlock.byAlreadyPlaced((Block)location.getBlock());
                    if (existingBlock != null) {
                        existingBlock.remove();
                    }
                    if ((block = CustomBlock.getInstance((String)customBlockId)) != null) {
                        block.place(location);
                        continue;
                    }
                    Skript.error((String)("Failed to get CustomBlock instance for ID: " + customBlockId));
                }
                catch (Exception ex) {
                    Skript.error((String)("An error occurred while placing custom block/crop: " + ex.getMessage()));
                    ex.printStackTrace();
                }
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        String itemTypeString = this.blockNames.toString(e, debug);
        String type = this.isCrop ? "crop" : "block";
        return "place custom " + type + " " + itemTypeString + " at " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPlaceBlockOrCrop.class, (String[])new String[]{"(set|place) [custom] (ia|itemsadder) (block|:crop) %customitemtypes/strings% [%directions% %locations%]", "set block at [%directions% %locations%] to [custom] (ia|itemsadder) (block|:crop) %customitemtypes/strings%"});
    }
}

