/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.FontImages.PlayerHudsHolderWrapper;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Update HUD")
@Description(value={"Update the player's currently enabled HUD."})
@Examples(value={"update player's current itemsadder hud"})
@Since(value="1.6")
@RequiredPlugins(value={"ItemsAdder"})
public class EffUpdateHUD
extends Effect {
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        Player[] p = (Player[])this.players.getArray(event);
        if (p != null) {
            for (Player players : p) {
                PlayerHudsHolderWrapper playerHudsHolderWrapper = new PlayerHudsHolderWrapper(players);
                if (!playerHudsHolderWrapper.exists()) continue;
                playerHudsHolderWrapper.sendUpdate();
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "update " + this.players.toString(event, debug) + " hud";
    }

    static {
        Skript.registerEffect(EffUpdateHUD.class, (String[])new String[]{"(update|refresh) %players%'[s] [current] [custom] (itemsadder|ia) hud"});
    }
}

