/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomEntity;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Spawn ItemsAdder Entity")
@Description(value={"Spawns an ItemsAdder entity."})
@Examples(value={"spawn itemsadder entity \"bosses:john_wick\" at player's location"})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EffSpawnCustomEntity
extends Effect {
    private Expression<String> entityIdExpr;
    private Expression<Location> locationExpr;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityIdExpr = exprs[0];
        this.locationExpr = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        String entityId = (String)this.entityIdExpr.getSingle(e);
        Location[] locations = (Location[])this.locationExpr.getArray(e);
        if (entityId == null || locations == null) {
            return;
        }
        for (Location location : locations) {
            CustomEntity customEntity = CustomEntity.spawn((String)entityId, (Location)location);
            if (customEntity != null) continue;
            Skript.error((String)"Please provide a valid CustomEntity ID.");
            return;
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "spawn custom entity " + this.entityIdExpr.toString(e, debug) + " at " + this.locationExpr.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSpawnCustomEntity.class, (String[])new String[]{"(spawn|summon) [the] [custom] (ia|itemsadder) (entity|mob) %string% at %locations%"});
    }
}

