/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.FontImages.TexturedInventoryWrapper;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Set Custom Inventory Slot")
@Description(value={"Set a slot of an ItemsAdder custom inventory, works like the regular Skript syntax."})
@Examples(value={"set slot 2 of custom {_g} to cooked beef # {_g} is the gui, stored in a variable, like Vanilla GUIs"})
@Since(value="1.5")
@RequiredPlugins(value={"ItemsAdder"})
public class EffSetInventoryIASlot
extends Effect {
    private Expression<TexturedInventoryWrapper> inventory;
    private Expression<Integer> slots;
    private Expression<ItemStack> items;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.slots = expressions[0];
        this.inventory = expressions[1];
        this.items = expressions[2];
        return true;
    }

    protected void execute(Event e) {
        Integer[] slotArray = (Integer[])this.slots.getArray(e);
        TexturedInventoryWrapper inventory = (TexturedInventoryWrapper)this.inventory.getSingle(e);
        ItemStack[] itemArray = (ItemStack[])this.items.getArray(e);
        for (int i = 0; i < slotArray.length && i < itemArray.length; ++i) {
            inventory.getInternal().setItem(slotArray[i].intValue(), itemArray[i]);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set slot " + this.slots.toString(e, debug) + " of " + this.inventory.toString(e, debug) + " to " + this.items.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetInventoryIASlot.class, (String[])new String[]{"set slot[s] %integers% of [custom] (ia|itemsadder) %texturedinventorywrapper% to %itemstacks%"});
    }
}

