/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.ItemsAdder;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Send ItemsAdder Resource Pack")
@Description(value={"Sends the most recently generated ItemsAdder resource pack to players."})
@Examples(value={"send current itemsadder resource pack to all players"})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EffSendIAResourcePack
extends Effect {
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        Player[] ps = (Player[])this.players.getArray(e);
        if (ps != null) {
            for (Player p : ps) {
                ItemsAdder.applyResourcepack((Player)p);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Apply ItemsAdder resource pack to " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSendIAResourcePack.class, (String[])new String[]{"(send|apply) [current] [custom] (ia|itemsadder) (texture|resource) pack to %players%"});
    }
}

