/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomPlayer;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Make Player Emote/Stop Emoting")
@Description(value={"Force player to emote/stop emoting"})
@Examples(value={"force all players to perform emote \"fortnite:default_dance\""})
@Since(value="1.0, 1.5 (slight syntax update)")
@RequiredPlugins(value={"ItemsAdder"})
public class EffPlayerEmote
extends Effect {
    private Expression<Player> players;
    private Expression<String> emote;
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.pattern = matchedPattern;
        if (matchedPattern == 0) {
            this.emote = exprs[1];
        }
        return true;
    }

    protected void execute(Event e) {
        block3: {
            Player[] ps;
            block4: {
                ps = (Player[])this.players.getArray(e);
                if (ps == null) break block3;
                if (this.pattern != 0) break block4;
                String emoteName = (String)this.emote.getSingle(e);
                if (emoteName == null) break block3;
                for (Player p : ps) {
                    CustomPlayer.playEmote((Player)p, (String)emoteName);
                }
                break block3;
            }
            if (this.pattern == 1) {
                for (Player p : ps) {
                    CustomPlayer.stopEmote((Player)p);
                }
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.pattern == 0 ? "make " + this.players.toString(e, debug) + " play animation " + this.emote.toString(e, debug) : "make " + this.players.toString(e, debug) + " stop emoting";
    }

    static {
        Skript.registerEffect(EffPlayerEmote.class, (String[])new String[]{"(make|force) %players% to perform [custom] [ia|itemsadder] (emote|dance|animation) %string%", "(make|force) %players% [to] stop [current] emot[e|ing]"});
    }
}

