/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.ItemsAdder;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Play ItemsAdder Totem Animation")
@Description(value={"Play a custom Totem Animation to players."})
@Examples(value={"play the custom totem animation \"celebrations:you_win\" to player"})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EffPlayIATotemAnimation
extends Effect {
    private Expression<Player> players;
    private Expression<String> totem;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.totem = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Player[] ps = (Player[])this.players.getArray(e);
        String totemName = (String)this.totem.getSingle(e);
        if (ps != null && totemName != null) {
            for (Player p : ps) {
                ItemsAdder.playTotemAnimation((Player)p, (String)totemName);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "play the custom totem animation " + this.totem.toString(e, debug) + " to " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPlayIATotemAnimation.class, (String[])new String[]{"(play|make) [the] [custom] (ia|itemsadder) totem [anim|animation] %string% to %players%"});
    }
}

