/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Play Break Effect")
@Description(value={"Plays the breaking effect on an ItemsAdder block, (not the cracking in case you were wondering.)"})
@Examples(value={"play break effect on target block"})
@Since(value="1.5")
@RequiredPlugins(value={"ItemsAdder"})
public class EffPlayBreakEffect
extends Effect {
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        Block[] blocksArray;
        for (Block block : blocksArray = (Block[])this.blocks.getArray(e)) {
            CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
            if (customBlock == null) continue;
            CustomBlock.playBreakEffect((Block)block);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "(show|play) break[ing] effect on " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffPlayBreakEffect.class, (String[])new String[]{"(show|play) break[ing] effect on [custom] (ia|itemsadder) %blocks%"});
    }
}

