/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.FontImages.TexturedInventoryWrapper;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Open ItemsAdder Inventory")
@Description(value={"Opens an ItemsAdder inventory to a player(s), made using the ItemsAdder inventory section."})
@Examples(value={"open custom itemsadder inventory {votegui} to all players"})
@Since(value="1.5")
@RequiredPlugins(value={"ItemsAdder"})
public class EffOpenCustomInventory
extends Effect {
    private Expression<Player> players;
    private Expression<TexturedInventoryWrapper> inventory;

    protected void execute(Event e) {
        Player[] ps = (Player[])this.players.getArray(e);
        TexturedInventoryWrapper inventory = (TexturedInventoryWrapper)this.inventory.getSingle(e);
        if (ps != null && inventory != null) {
            for (Player p : ps) {
                inventory.showInventory(p);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "open " + this.inventory.toString(e, debug) + " to " + this.players.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inventory = exprs[0];
        this.players = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffOpenCustomInventory.class, (String[])new String[]{"(show|open) [a[n]|the] [custom] (ia|itemsadder) [inventory] %texturedinventorywrapper% to %players%"});
    }
}

