/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomEntity;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Make Entity Play Animation")
@Description(value={"Makes an ItemsAdder entity play an animation."})
@Examples(value={"on right click:", "\tif clicked entity is an itemsadder entity", "\t\tmake clicked entity play itemsadder animation \"fortnite:default_dance\""})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EffMakeEntityPlayAnimation
extends Effect {
    private Expression<Entity> entityExpr;
    private Expression<String> animationIdExpr;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpr = exprs[0];
        this.animationIdExpr = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Entity[] entities = (Entity[])this.entityExpr.getArray(e);
        String animationId = (String)this.animationIdExpr.getSingle(e);
        if (entities == null || animationId == null) {
            return;
        }
        for (Entity entity : entities) {
            CustomEntity customEntity = CustomEntity.byAlreadySpawned((Entity)entity);
            if (customEntity == null) continue;
            customEntity.playAnimation(animationId);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entityExpr.toString(e, debug) + " play animation " + this.animationIdExpr.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffMakeEntityPlayAnimation.class, (String[])new String[]{"(make|force) %entities% [to] play [custom] (ia|itemsadder) (anim[ation]) %string%"});
    }
}

