/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomEntity;
import javax.annotation.Nullable;
import jdk.jfr.Description;
import jdk.jfr.Name;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Damage Effect")
@Description(value="Play the red damage effect on an ItemsAdder entity.")
@Examples(value={"play damage effect on custom itemsadder entity {_iaentity}"})
@Since(value="1.6")
@RequiredPlugins(value={"ItemsAdder"})
public class EffDamageEffect
extends Effect {
    private Expression<Entity> entitiesExpr;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entitiesExpr = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities;
        for (Entity entity : entities = (Entity[])this.entitiesExpr.getArray(event)) {
            CustomEntity customEntity = CustomEntity.byAlreadySpawned((Entity)entity);
            if (customEntity == null) continue;
            customEntity.playDamageEffect(false);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "show damage effect on itemsadder entity " + this.entitiesExpr.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffDamageEffect.class, (String[])new String[]{"(show|play) [the] damage effect on [custom] (itemsadder|ia) entit[y|ies] %entities%"});
    }
}

