/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.aliases.CustomItemType;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Is ItemsAdder Item")
@Description(value={"Checks if the item is an ItemsAdder item."})
@Examples(value={"if player's tool is a custom item", "if player's tool is a custom item \"icon_arrow_chest\""})
@Since(value="1.0, 1.5 (Negative comparison)")
@RequiredPlugins(value={"ItemsAdder"})
public class CondIsCustomItem
extends Condition {
    private Expression<ItemStack> items;
    private Expression<Object> ids;
    private boolean negated;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = expressions[0];
        this.ids = expressions[1];
        this.negated = matchedPattern == 1;
        return true;
    }

    public boolean check(Event event) {
        List expectedIds = Arrays.stream(this.ids.getArray(event)).map(id -> {
            if (id instanceof CustomItemType) {
                return ((CustomItemType)id).getNamespacedID();
            }
            if (id instanceof String) {
                return (String)id;
            }
            return null;
        }).filter(id -> id != null).collect(Collectors.toList());
        boolean allMatch = ((ItemStack[])this.items.getArray(event)).length > 0;
        for (ItemStack itemStack : (ItemStack[])this.items.getArray(event)) {
            boolean matches;
            CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
            boolean bl = matches = customStack != null && expectedIds.contains(customStack.getId());
            if ((!this.negated || !matches) && (this.negated || matches)) continue;
            allMatch = false;
            break;
        }
        return allMatch;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String itemString = this.items.toString(event, debug);
        String idString = this.ids.toString(event, debug);
        return itemString + (this.negated ? " isn't" : " is") + " a custom item" + (String)(idString != null ? " with id " + idString : "");
    }

    static {
        Skript.registerCondition(CondIsCustomItem.class, (String[])new String[]{"%itemstacks% (is [a[n]]|are) [custom] (ia|itemsadder) item[s] [[with id] %-customitemtypes/strings%]", "%itemstacks% (is[n't| not]) [a] [custom] (ia|itemsadder) item[s] [[with id] %-customitemtypes/strings%]"});
    }
}

