/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomEntity;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Is ItemsAdder Entity")
@Description(value={"Checks if the entity is an ItemsAdder entity."})
@Examples(value={"on damage:", "\tif event-entity is an itemsadder entity:", "\t\tsend \"how could you?\" to player", "\telse if event-entity is not an itemsadder entity:", "\t\t send \"Incredible!\" to player "})
@Since(value="1.0, 1.5 (Negative Comparison)")
@RequiredPlugins(value={"ItemsAdder"})
public class CondIsCustomEntity
extends Condition {
    private Expression<Entity> entities;
    private Expression<String> entityId;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.entityId = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        for (Entity entity : (Entity[])this.entities.getArray(e)) {
            String id;
            CustomEntity customEntity = CustomEntity.byAlreadySpawned((Entity)entity);
            if (customEntity == null) {
                return this.isNegated();
            }
            if (this.entityId == null || (id = (String)this.entityId.getSingle(e)) != null && customEntity.getId().equals(id)) continue;
            return this.isNegated();
        }
        return !this.isNegated();
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.entities.toString(e, debug) + (this.isNegated() ? " isn't" : " is") + " a custom entity" + (String)(this.entityId != null ? " with id " + this.entityId.toString(e, debug) : "");
    }

    static {
        Skript.registerCondition(CondIsCustomEntity.class, (String[])new String[]{"%entities% (is [a[n]]|are) [custom] (ia|itemsadder) entit(y|ies) [[with id] %-string%]", "%entities% (is[n't| not]) [a] [custom] (ia|itemsadder) entit(y|ies) [[with id] %-string%]"});
    }
}

