/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.aliases.CustomItemType;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Is ItemsAdder Block")
@Description(value={"Checks if the block is an ItemsAdder block."})
@Examples(value={"on break:", "\tif event-block is a custom block with id \"iasurvival:ruby_block\":", "\t\tkill player", "\telse if event-block isn't a custom block:", "\t\tsend \"Good Job!\" to player"})
@Since(value="1.0, 1.5 (Negative Comparison)")
@RequiredPlugins(value={"ItemsAdder"})
public class CondIsCustomBlock
extends Condition {
    private Expression<Block> blocks;
    private Expression<Object> ids;
    private boolean negated;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = expressions[0];
        this.ids = expressions[1];
        this.negated = matchedPattern == 1;
        return true;
    }

    public boolean check(Event event) {
        List expectedIds = this.ids.stream(event).map(id -> {
            if (id instanceof CustomItemType) {
                return ((CustomItemType)id).getNamespacedID();
            }
            if (id instanceof String) {
                return (String)id;
            }
            return null;
        }).filter(id -> id != null).collect(Collectors.toList());
        boolean allMatch = ((Block[])this.blocks.getArray(event)).length > 0;
        for (Block block : (Block[])this.blocks.getArray(event)) {
            boolean matches;
            CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
            boolean bl = matches = customBlock != null && expectedIds.contains(customBlock.getId());
            if ((!this.negated || !matches) && (this.negated || matches)) continue;
            allMatch = false;
            break;
        }
        return allMatch;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String blockString = this.blocks.toString(event, debug);
        String idString = this.ids.toString(event, debug);
        return blockString + (this.negated ? " isn't" : " is") + " a custom block" + (String)(idString != null ? " with id " + idString : "");
    }

    static {
        Skript.registerCondition(CondIsCustomBlock.class, (String[])new String[]{"%blocks% (is [a[n]]|are) [custom] (ia|itemsadder) block[s] [[with id] %-customitemtypes/strings%]", "%blocks% (isn't|is not|aren't|are not) [a] [custom] (ia|itemsadder) block[s] [[with id] %-customitemtypes/strings%]"});
    }
}

