/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.FontImages.PlayerHudWrapper;
import dev.lone.itemsadder.api.FontImages.PlayerHudsHolderWrapper;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="HUD Is Visible")
@Description(value={"Determines whether players can see a hud/if a hud is active."})
@Examples(value={"if player can see itemsadder hud \"namespaced:id\""})
@Since(value="1.6")
@RequiredPlugins(value={"ItemsAdder"})
public class CondHUDIsVisible
extends Condition {
    private Expression<Player> players;
    private Expression<String> hudID;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.hudID = exprs[1];
        return true;
    }

    public boolean check(Event event) {
        Player[] p = (Player[])this.players.getArray(event);
        String id = (String)this.hudID.getSingle(event);
        if (id != null) {
            int n = 0;
            Player[] playerArray = p;
            int n2 = playerArray.length;
            if (n < n2) {
                Player players = playerArray[n];
                PlayerHudsHolderWrapper hudsHolder = new PlayerHudsHolderWrapper(players);
                PlayerHudWrapper hudWrapper = new PlayerHudWrapper(hudsHolder, id);
                return hudWrapper.isVisible();
            }
            return false;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.players.toString(event, debug) + "can view itemsadder hud " + this.hudID.toString(event, debug);
    }

    static {
        Skript.registerCondition(CondHUDIsVisible.class, (String[])new String[]{"%players% can (see|view) [custom] (ia|itemsadder) hud %string%"});
    }
}

