/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.aliases;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.AliasesProvider;
import ch.njol.skript.aliases.InvalidMinecraftIdException;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.ItemsAdder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AliasesGenerator {
    private final SkriptItemsAdder plugin;
    private final File aliasesFile;
    private FileConfiguration aliasesConfig;
    private final Map<String, String> itemAliases = new ConcurrentHashMap<String, String>();
    private final Set<String> generatedAliases = ConcurrentHashMap.newKeySet();

    public AliasesGenerator(SkriptItemsAdder plugin) {
        this.plugin = plugin;
        this.aliasesFile = new File(plugin.getDataFolder(), "aliases.yml");
        this.loadAliasesFile();
        this.loadAliasesFromFile();
    }

    public void loadAliasesFile() {
        if (!this.aliasesFile.exists()) {
            this.aliasesFile.getParentFile().mkdirs();
            this.plugin.saveResource("aliases.yml", false);
        }
        this.aliasesConfig = YamlConfiguration.loadConfiguration((File)this.aliasesFile);
    }

    public void loadAliasesFromFile() {
        if (this.aliasesConfig.contains("items")) {
            for (String key : this.aliasesConfig.getConfigurationSection("items").getKeys(false)) {
                this.itemAliases.put(key, this.aliasesConfig.getString("items." + key));
            }
        }
    }

    private void saveAliasesToFile() {
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<String, String> entry : AliasesGenerator.this.itemAliases.entrySet()) {
                    AliasesGenerator.this.aliasesConfig.set("items." + entry.getKey(), (Object)entry.getValue());
                }
                try {
                    AliasesGenerator.this.aliasesConfig.save(AliasesGenerator.this.aliasesFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private String generateUniqueAlias(String baseAlias) {
        Object uniqueAlias = baseAlias;
        int counter = 1;
        while (this.itemAliases.containsKey(uniqueAlias)) {
            uniqueAlias = baseAlias + "_" + counter;
            ++counter;
        }
        return uniqueAlias;
    }

    private String generateAliasForItem(CustomStack item) {
        String baseAlias = item.getId().toLowerCase().replace("_", " ");
        if (this.itemAliases.containsValue(baseAlias)) {
            return this.generateUniqueAlias(baseAlias);
        }
        return baseAlias;
    }

    private void registerAlias(String alias, String namespacedId) {
        this.itemAliases.put(alias, namespacedId);
        this.generatedAliases.add(alias);
        AliasesProvider addonProvider = Aliases.getAddonProvider((SkriptAddon)Skript.getAddonInstance());
        AliasesProvider.AliasName aliasName = new AliasesProvider.AliasName(alias, alias, 0);
        try {
            addonProvider.addAlias(aliasName, namespacedId, null, new HashMap());
        }
        catch (InvalidMinecraftIdException invalidMinecraftIdException) {
            // empty catch block
        }
    }

    public void generateAliasesForAllItems() {
        new BukkitRunnable(){

            public void run() {
                List allItems = ItemsAdder.getAllItems();
                Set currentNamespaces = allItems.stream().map(CustomStack::getNamespacedID).collect(Collectors.toSet());
                boolean allAliasesExist = currentNamespaces.stream().allMatch(AliasesGenerator.this.itemAliases::containsValue);
                if (allAliasesExist && currentNamespaces.size() == AliasesGenerator.this.itemAliases.size()) {
                    return;
                }
                for (CustomStack item : allItems) {
                    String namespacedId = item.getNamespacedID();
                    if (AliasesGenerator.this.itemAliases.containsValue(namespacedId)) continue;
                    String alias2 = AliasesGenerator.this.generateAliasForItem(item);
                    AliasesGenerator.this.registerAlias(alias2, namespacedId);
                }
                Set unusedAliases = AliasesGenerator.this.itemAliases.keySet().stream().filter(alias -> !AliasesGenerator.this.generatedAliases.contains(alias)).collect(Collectors.toSet());
                for (String unusedAlias : unusedAliases) {
                    AliasesGenerator.this.itemAliases.remove(unusedAlias);
                }
                AliasesGenerator.this.saveAliases();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void syncAliasesWithProvider() {
        AliasesProvider addonProvider = Aliases.getAddonProvider((SkriptAddon)Skript.getAddonInstance());
        addonProvider.clearAliases();
        for (Map.Entry<String, String> entry : this.itemAliases.entrySet()) {
            AliasesProvider.AliasName aliasName = new AliasesProvider.AliasName(entry.getKey(), entry.getKey(), 0);
            try {
                addonProvider.addAlias(aliasName, entry.getValue(), null, new HashMap());
            }
            catch (InvalidMinecraftIdException invalidMinecraftIdException) {}
        }
    }

    public String getNamespacedId(String alias) {
        return this.itemAliases.get(alias);
    }

    public void saveAliases() {
        this.saveAliasesToFile();
    }

    @Generated
    public Set<String> getGeneratedAliases() {
        return this.generatedAliases;
    }
}

