/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Version;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.Generated;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.listeners.ItemsAdderEventListener;
import me.asleepp.SkriptItemsAdder.util.Metrics;
import me.asleepp.SkriptItemsAdder.util.SkriptItemsAdderCommand;
import me.asleepp.SkriptItemsAdder.util.UpdateChecker;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptItemsAdder
extends JavaPlugin {
    private static SkriptAddon addon;
    private static SkriptItemsAdder instance;
    private AliasesGenerator aliasesGenerator;
    private final PluginManager manager = this.getServer().getPluginManager();

    @Nullable
    public static SkriptItemsAdder getInstance() {
        return instance;
    }

    @Nullable
    public static SkriptAddon getAddonInstance() {
        return addon;
    }

    public void onEnable() {
        long start = System.currentTimeMillis();
        Plugin skript = this.manager.getPlugin("Skript");
        if (skript == null || !skript.isEnabled()) {
            this.getLogger().severe("Could not find Skript! Disabling...");
            this.manager.disablePlugin((Plugin)this);
            return;
        }
        if (Skript.getVersion().isSmallerThan(new Version(new int[]{2, 7, 0}))) {
            this.getLogger().severe("You are running an unsupported version of Skript. Disabling...");
            this.manager.disablePlugin((Plugin)this);
            return;
        }
        if (!Skript.isAcceptRegistrations()) {
            this.getLogger().severe("The plugin can't load when it's already loaded! Disabling...");
            this.manager.disablePlugin((Plugin)this);
            return;
        }
        Plugin itemsadder = this.manager.getPlugin("ItemsAdder");
        if (itemsadder == null || !itemsadder.isEnabled()) {
            this.getLogger().severe("Could not find ItemsAdder! Disabling...");
            this.manager.disablePlugin((Plugin)this);
            return;
        }
        this.aliasesGenerator = new AliasesGenerator(this);
        SkriptItemsAdder plugin = this;
        ItemsAdderEventListener eventListener = new ItemsAdderEventListener(plugin, this.aliasesGenerator);
        this.manager.registerEvents((Listener)eventListener, (Plugin)plugin);
        int pluginId = 20971;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
        metrics.addCustomChart(new Metrics.SimplePie("itemsadder_version", () -> Util.getPluginVersion("ItemsAdder")));
        instance = this;
        addon = Skript.registerAddon((JavaPlugin)this);
        addon.setLanguageFileDirectory("lang");
        new SkriptItemsAdderCommand(this);
        this.saveDefaultConfig();
        try {
            addon.loadClasses("me.asleepp.SkriptItemsAdder", new String[]{"elements"});
        }
        catch (IOException error) {
            error.printStackTrace();
            this.manager.disablePlugin((Plugin)this);
            return;
        }
        if (this.getConfig().getBoolean("check-for-updates", true)) {
            new UpdateChecker(this);
        }
        long finish = System.currentTimeMillis() - start;
        this.getLogger().info("Successfully loaded skript-itemsadder in " + finish + "ms!");
        eventListener.generateAliases();
    }

    public void onDisable() {
    }

    @Generated
    public AliasesGenerator getAliasesGenerator() {
        return this.aliasesGenerator;
    }
}

