/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.worldguard;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.TextUtil;
import be.isach.ultracosmetics.worldguard.CosmeticRegionState;
import be.isach.ultracosmetics.worldguard.FlagManager;
import be.isach.ultracosmetics.worldguard.IFlagManager;
import be.isach.ultracosmetics.worldguard.UCFlag;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldGuardManager {
    private final UltraCosmetics ultraCosmetics;
    private IFlagManager flagManager;

    public WorldGuardManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public void register() {
        try {
            this.flagManager = new FlagManager();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Couldn't find required classes for WorldGuard integration.");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Please make sure you are using the latest version of WorldGuard");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "for your version of Minecraft. Debug info:");
            e.printStackTrace();
            this.ultraCosmetics.getSmartLogger().write("WorldGuard support is disabled.");
            this.ultraCosmetics.addProblem(Problem.WORLDGUARD_HOOK_FAILURE);
            return;
        }
        this.flagManager.register();
    }

    public void registerPhase2() {
        if (this.flagManager == null) {
            return;
        }
        SmartLogger log = this.ultraCosmetics.getSmartLogger();
        if (!Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            log.write(SmartLogger.LogLevel.ERROR, "WorldGuard is not enabled yet! Is WorldGuard up to date? Is another plugin interfering with the load order?");
            log.write(SmartLogger.LogLevel.ERROR, "WorldGuard support will be disabled.");
            this.ultraCosmetics.addProblem(Problem.WORLDGUARD_HOOK_FAILURE);
            return;
        }
        this.flagManager.registerPhase2();
        log.write(new Object[0]);
        log.write("WorldGuard custom flags enabled");
    }

    public boolean areCosmeticsAllowedHere(Player player, Category category) {
        return this.allowedCosmeticsState(player, category) == CosmeticRegionState.ALLOWED;
    }

    public CosmeticRegionState allowedCosmeticsState(Player player, Category category) {
        if (this.flagManager == null) {
            return CosmeticRegionState.ALLOWED;
        }
        if (!this.flagManager.flagCheck(UCFlag.COSMETICS, player)) {
            return CosmeticRegionState.BLOCKED_ALL;
        }
        if (category != null && !this.categoryFlagCheck(player, category)) {
            return CosmeticRegionState.BLOCKED_CATEGORY;
        }
        return CosmeticRegionState.ALLOWED;
    }

    public boolean canAffectPlayersHere(Player player) {
        if (this.flagManager == null) {
            return true;
        }
        return this.flagManager.flagCheck(UCFlag.COSMETICS, player) && this.flagManager.flagCheck(UCFlag.AFFECT_PLAYERS, player);
    }

    public boolean areChestsAllowedHere(Player player) {
        if (this.flagManager == null) {
            return true;
        }
        return this.flagManager.flagCheck(UCFlag.TREASURE, player);
    }

    public boolean isInShowroom(Player player) {
        if (this.flagManager == null) {
            return false;
        }
        return this.flagManager.flagCheck(UCFlag.SHOWROOM, player);
    }

    public void doCosmeticCheck(Player player, UltraCosmetics uc) {
        if (this.flagManager == null) {
            return;
        }
        if (!this.flagManager.flagCheck(UCFlag.COSMETICS, player) && uc.getPlayerManager().getUltraPlayer(player).clear()) {
            MessageManager.send((CommandSender)player, "Region-Disabled", new TagResolver.Single[0]);
            return;
        }
        Set<Category> blockedCategories = this.flagManager.categoryFlagCheck(player);
        if (blockedCategories == null) {
            return;
        }
        for (Category category : blockedCategories) {
            if (!blockedCategories.contains((Object)category) || !uc.getPlayerManager().getUltraPlayer(player).removeCosmetic(category)) continue;
            TagResolver.Single placeholder = Placeholder.component("category", TextUtil.stripColor(MessageManager.getMessage("Menu." + category.getConfigPath() + ".Title", new TagResolver.Single[0])));
            MessageManager.send((CommandSender)player, "Region-Disabled-Category", placeholder);
        }
    }

    protected boolean categoryFlagCheck(Player player, Category category) {
        Set<Category> categories = this.flagManager.categoryFlagCheck(player);
        return categories == null || !categories.contains((Object)category);
    }

    public void noCosmeticsRegionEntered(UltraPlayer ultraPlayer) {
        if (ultraPlayer.clear()) {
            MessageManager.send((CommandSender)ultraPlayer.getBukkitPlayer(), "Region-Disabled", new TagResolver.Single[0]);
        }
    }

    public void restrictedCosmeticsChange(UltraPlayer ultraPlayer, Set<Category> restrictions) {
        Player bukkitPlayer = ultraPlayer.getBukkitPlayer();
        for (Category cat : restrictions) {
            if (!ultraPlayer.removeCosmetic(cat)) continue;
            MessageManager.send((CommandSender)bukkitPlayer, "Region-Disabled-Category", Placeholder.component("category", MessageManager.getMessage("Menu." + cat.getConfigPath() + ".Title", new TagResolver.Single[0])));
        }
    }

    public void showroomFlagChange(UltraPlayer ultraPlayer, boolean newValue) {
        if (!newValue) {
            for (Category cat : Category.values()) {
                Cosmetic<?> cosmetic = ultraPlayer.getCosmetic(cat);
                if (cosmetic == null || this.ultraCosmetics.getPermissionManager().hasPermission(ultraPlayer, (CosmeticType<?>)cosmetic.getType())) continue;
                ultraPlayer.removeCosmetic(cat);
            }
        }
        if (ultraPlayer.hasCosmetic(Category.GADGETS)) {
            this.ultraCosmetics.getScheduler().runAtEntity((Entity)ultraPlayer.getBukkitPlayer(), task -> {
                Gadget gadget = ultraPlayer.getCurrentGadget();
                if (gadget == null) {
                    return;
                }
                gadget.equipItem();
            });
        }
    }

    public boolean isHooked() {
        return this.flagManager != null;
    }
}

