/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.Version;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class UpdateManager
extends UltraTask {
    private static final String RESOURCE_URL = "https://api.spiget.org/v2/resources/10905/";
    private static final String VERSIONS_PREFIX = " Supported versions: ";
    private final Version currentVersion;
    private Version spigotVersion;
    private final UltraCosmetics ultraCosmetics;
    private boolean outdated = false;
    private String status;

    public UpdateManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        Reader reader = UltraCosmeticsData.get().getPlugin().getFileReader("build_info.yml");
        YamlConfiguration buildInfo = YamlConfiguration.loadConfiguration((Reader)reader);
        String gitHash = buildInfo.getString("git-hash");
        this.currentVersion = new Version(ultraCosmetics.getDescription().getVersion(), gitHash);
    }

    @Override
    public void run() {
        this.determineStatus();
        this.ultraCosmetics.getSmartLogger().write(this.status);
        if (this.outdated && SettingsManager.getConfig().getBoolean("Auto-Update")) {
            this.update();
        }
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runLaterAsync(this::run, 1L);
    }

    private void determineStatus() {
        String spigotVersionString = this.fetchSpigotVersion();
        if (spigotVersionString == null) {
            this.status = "Cannot update, unknown version";
            return;
        }
        this.spigotVersion = new Version(spigotVersionString);
        if (this.currentVersion.compareTo(this.spigotVersion) == 0) {
            this.status = "You are running the latest version on Spigot.";
            return;
        }
        if (this.currentVersion.compareTo(this.spigotVersion) > 0) {
            this.status = "You are running a version newer than the latest one on Spigot.";
            return;
        }
        if (!this.checkMinecraftVersion()) {
            this.status = "A new version is available on Spigot, but it doesn't support this server version.";
            return;
        }
        this.outdated = true;
        this.status = "New version available on Spigot: " + this.spigotVersion.numbersOnly();
    }

    public boolean update() {
        if (!this.download()) {
            this.ultraCosmetics.getSmartLogger().write("Failed to download update");
            return false;
        }
        this.outdated = false;
        this.status = "Successfully downloaded new version, restart server to apply update.";
        this.ultraCosmetics.getSmartLogger().write(this.status);
        return true;
    }

    private String fetchSpigotVersion() {
        JsonObject jsonVersion = (JsonObject)this.apiRequest("versions/latest");
        if (jsonVersion == null) {
            return null;
        }
        String version = jsonVersion.get("name").getAsString();
        return version;
    }

    public Version getSpigotVersion() {
        return this.spigotVersion;
    }

    public Version getCurrentVersion() {
        return this.currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement apiRequest(String suffix) {
        InputStreamReader reader = null;
        try {
            JsonElement response;
            URL url = new URL(RESOURCE_URL + suffix);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "UltraCosmetics Update Checker");
            InputStream inputStream = connection.getInputStream();
            reader = new InputStreamReader(inputStream);
            JsonElement jsonElement = response = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to check for an update on spigot.");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download() {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL("https://api.spiget.org/v2/resources/10905/download");
            in = new BufferedInputStream(url.openStream());
            File outputFile = new File(Bukkit.getUpdateFolderFile(), "UltraCosmetics-" + this.spigotVersion.numbersOnly() + "-RELEASE.jar");
            outputFile.getParentFile().mkdirs();
            fout = new FileOutputStream(outputFile);
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                this.ultraCosmetics.getLogger().log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
        }
    }

    private boolean checkMinecraftVersion() {
        JsonObject update = (JsonObject)this.apiRequest("updates/latest");
        String description = new String(Base64.getDecoder().decode(update.get("description").getAsString()));
        String[] lines = description.split("\\<br\\>");
        String supportedVersionsLine = lines[lines.length - 1];
        if (!supportedVersionsLine.startsWith(VERSIONS_PREFIX)) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Can't read supported versions line:");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, supportedVersionsLine);
            return false;
        }
        supportedVersionsLine = supportedVersionsLine.substring(VERSIONS_PREFIX.length());
        String[] supportedVersions = supportedVersionsLine.split(", ");
        String thisMinecraftVersion = Bukkit.getBukkitVersion();
        thisMinecraftVersion = thisMinecraftVersion.substring(0, thisMinecraftVersion.indexOf(45));
        String[] tmvParts = thisMinecraftVersion.split("\\.");
        String[] supportedParts = supportedVersions[supportedVersions.length - 1].split("\\.");
        for (int i = 0; i < tmvParts.length; ++i) {
            if (i >= supportedParts.length) {
                return false;
            }
            int tmvPart = Integer.parseInt(tmvParts[i]);
            int supportedPart = Integer.parseInt(supportedParts[i]);
            if (supportedPart > tmvPart) {
                return true;
            }
            if (supportedPart >= tmvPart) continue;
            return false;
        }
        return true;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public String getStatus() {
        return this.status;
    }
}

