/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.util.Area;
import com.cryptomorin.xseries.XBlock;
import com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class StructureRollback
implements Listener {
    private static final Set<StructureRollback> INSTANCES = new HashSet<StructureRollback>();
    private final HashMap<Block, BlockState> states = new LinkedHashMap<Block, BlockState>();
    private Area protectionArea;

    public static boolean isBlockRollingBack(Block block) {
        for (StructureRollback rollback : INSTANCES) {
            if (!rollback.containsBlock(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockRollingBackInArea(Area area) {
        Iterator<StructureRollback> iterator = INSTANCES.iterator();
        if (iterator.hasNext()) {
            StructureRollback rollback = iterator.next();
            if (rollback.protectionArea != null) {
                return rollback.protectionArea.overlapsWith(area);
            }
            for (Block block : rollback.states.keySet()) {
                if (!area.contains(block)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public StructureRollback() {
        this(null);
    }

    public StructureRollback(Area protectionArea) {
        this.protectionArea = protectionArea;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)UltraCosmeticsData.get().getPlugin());
        INSTANCES.add(this);
    }

    public boolean containsBlock(Block block) {
        return this.states.containsKey(block);
    }

    public void setToRestore(Block block, XMaterial newType) {
        this.setToRestore(block, newType, true);
    }

    public void setToRestore(Block block, Material newType) {
        this.setToRestore(block, newType, true);
    }

    public void setToRestore(Block block, XMaterial newType, boolean applyPhysics) {
        this.states.put(block, block.getState());
        XBlock.setType((Block)block, (XMaterial)newType, (boolean)applyPhysics);
    }

    public void setToRestore(Block block, Material newType, boolean applyPhysics) {
        this.states.put(block, block.getState());
        block.setType(newType, applyPhysics);
    }

    public Area getProtectionArea() {
        return this.protectionArea;
    }

    public void updateProtectionArea(Area area) {
        this.protectionArea = area;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.states.containsKey(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (this.protectionArea != null && this.protectionArea.contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        event.blockList().removeAll(this.states.keySet());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().removeAll(this.states.keySet());
    }

    public void rollback() {
        ListIterator<BlockState> iter = new ArrayList<BlockState>(this.states.values()).listIterator(this.states.size());
        while (iter.hasPrevious()) {
            iter.previous().update(true);
        }
        this.states.clear();
    }

    public void cleanup() {
        this.rollback();
        HandlerList.unregisterAll((Listener)this);
        INSTANCES.remove(this);
    }
}

