/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.task.UltraTask;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockViewUpdater
extends UltraTask {
    private static final Set<Block> blocksUpdating = ConcurrentHashMap.newKeySet();
    private final Set<Block> blocks;
    private final int delay;

    public BlockViewUpdater(Set<Block> blocks, int delay) {
        this.blocks = blocks;
        this.delay = delay;
        BlockViewUpdater.addForProcessing(blocks);
    }

    @Override
    public void run() {
        BlockViewUpdater.removeForProcessing(this.blocks);
        for (Block block : this.blocks) {
            for (Player player : block.getWorld().getPlayers()) {
                player.sendBlockChange(block.getLocation(), block.getBlockData());
            }
        }
    }

    @Override
    public void schedule() {
        if (this.blocks.isEmpty()) {
            return;
        }
        Location location = this.blocks.iterator().next().getLocation();
        this.task = this.getScheduler().runAtLocationLater(location, this::run, (long)this.delay);
    }

    public static boolean isUpdating(Block block) {
        return blocksUpdating.contains(block);
    }

    private static synchronized void addForProcessing(Set<Block> blocks) {
        blocks.removeAll(blocksUpdating);
        blocksUpdating.addAll(blocks);
    }

    private static synchronized void removeForProcessing(Set<Block> blocks) {
        blocksUpdating.removeAll(blocks);
    }
}

