/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.util.MathUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerBounceRunnable
extends UltraTask {
    private final TreasureChest chest;
    private final Location center;
    private final int searchDistance;
    private final Player player;
    private final UltraPlayer ultraPlayer;
    private final UltraPlayerManager pm = UltraCosmeticsData.get().getPlugin().getPlayerManager();

    public PlayerBounceRunnable(TreasureChest chest) {
        this.chest = chest;
        this.center = chest.getCenter();
        this.player = chest.getPlayer();
        this.ultraPlayer = UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(this.player);
        this.searchDistance = chest.isLarge() ? 3 : 2;
    }

    @Override
    public void run() {
        if (this.ultraPlayer.getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        if (this.player.getWorld() != this.center.getWorld() || this.player.getLocation().distanceSquared(this.center) > 2.25) {
            this.getScheduler().teleportAsync((Entity)this.player, this.center);
        }
        for (Entity ent : this.player.getNearbyEntities((double)this.searchDistance, (double)this.searchDistance, (double)this.searchDistance)) {
            if (!TreasureChestManager.shouldPush(this.ultraPlayer, ent) || this.chest.isSpecialEntity(ent)) continue;
            Vector v = ent.getLocation().toVector().subtract(this.player.getLocation().toVector()).multiply(0.5).setY(1);
            MathUtils.applyVelocity(ent, v.add(MathUtils.getRandomCircleVector().multiply(0.2)));
        }
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runAtEntityTimer((Entity)this.ultraPlayer.getBukkitPlayer(), this::run, 5L, 1L);
    }
}

