/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.treasurechests.ChestBlockPattern;
import be.isach.ultracosmetics.treasurechests.ChestParticleRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import com.cryptomorin.xseries.XMaterial;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlaceBlocksRunnable
extends UltraTask {
    private final TreasureChest chest;
    private final TreasureChestDesign design;
    private final boolean large;
    private final UltraCosmetics uc = UltraCosmeticsData.get().getPlugin();
    private int i = 6;
    private ChestParticleRunnable particleRunnable = null;

    public PlaceBlocksRunnable(TreasureChest chest) {
        this.chest = chest;
        this.design = chest.getDesign();
        this.large = chest.isLarge();
    }

    @Override
    public void run() {
        Player player = this.chest.getPlayer();
        UltraPlayerManager pm = this.uc.getPlayerManager();
        if (player == null || pm.getUltraPlayer(player).getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        if (this.i <= 0) {
            this.particleRunnable = new ChestParticleRunnable(this.chest);
            this.particleRunnable.schedule();
            this.cancel();
            return;
        }
        this.doChestStages(player);
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runAtLocationTimer(this.chest.getCenter(), this::run, 1L, 12L);
    }

    private void doChestStages(Player player) {
        if (this.i == 6) {
            this.doChestStage(player.getLocation().subtract(0.0, 1.0, 0.0), ChestBlockPattern.CENTER_BLOCK, this.design.getCenter());
        }
        if (this.i == 5) {
            boolean executed = this.doChestStage(this.chest.getCenter().add(0.0, -1.0, 0.0), ChestBlockPattern.AROUND_CENTER, this.design.getBlocks2());
            if (!this.large) {
                --this.i;
                if (executed) {
                    --this.i;
                    return;
                }
            }
        }
        if (this.i == 4) {
            this.doChestStage(this.chest.getCenter().add(0.0, -1.0, 0.0), ChestBlockPattern.LARGE_AROUND_AROUND, this.design.getBlocks2());
        }
        if (this.i == 3) {
            this.doChestStage(this.chest.getCenter().add(0.0, -1.0, 0.0), this.large ? ChestBlockPattern.LARGE_CORNERS : ChestBlockPattern.CORNERS, this.design.getBlocks3());
        }
        if (this.i == 2) {
            this.doChestStage(this.chest.getCenter().add(0.0, -1.0, 0.0), this.large ? ChestBlockPattern.LARGE_BELOW_CHEST : ChestBlockPattern.BELOW_CHEST, this.design.getBelowChests());
        }
        if (this.i == 1) {
            this.doChestStage(this.chest.getCenter(), this.large ? ChestBlockPattern.LARGE_CORNERS : ChestBlockPattern.CORNERS, this.design.getBarriers());
        }
        --this.i;
    }

    private boolean doChestStage(Location center, ChestBlockPattern pattern, XMaterial newData) {
        if (newData == null) {
            --this.i;
            return false;
        }
        pattern.loop(center, loc -> this.chest.addRestoreBlock(loc.getBlock(), newData));
        return true;
    }

    public void propagateCancel() {
        this.cancel();
        if (this.particleRunnable != null) {
            this.particleRunnable.propogateCancel();
        }
    }
}

