/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.ai.controller;

import be.isach.ultracosmetics.shaded.mobchip.ai.controller.NaturalMoveType;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public interface EntityController {
    public EntityController jump();

    default public EntityController lookAt(@NotNull Entity en) {
        return this.lookAt(en.getLocation());
    }

    default public EntityController lookAt(@NotNull Location loc) {
        return this.lookAt(loc.getX(), loc.getY(), loc.getZ());
    }

    public EntityController lookAt(double var1, double var3, double var5);

    default public EntityController moveTo(@NotNull Entity en) {
        return this.moveTo(en, 1.0);
    }

    default public EntityController moveTo(@NotNull Entity en, double speedMod) {
        return this.moveTo(en.getLocation(), speedMod);
    }

    default public EntityController moveTo(@NotNull Location loc) {
        return this.moveTo(loc, 1.0);
    }

    default public EntityController moveTo(@NotNull Location loc, double speedMod) {
        return this.moveTo(loc.getX(), loc.getY(), loc.getZ(), speedMod);
    }

    default public EntityController moveTo(double x, double y, double z) {
        return this.moveTo(x, y, z, 1.0);
    }

    public EntityController moveTo(double var1, double var3, double var5, double var7);

    public EntityController naturalMoveTo(double var1, double var3, double var5, NaturalMoveType var7);

    public EntityController strafe(float var1, float var2);

    public double getCurrentSpeedModifier();

    public Location getTargetMoveLocation();

    public Location getTargetLookLocation();

    public boolean isLookingAtTarget();

    @NotNull
    public Vector getDeltaMovement();

    public void setDeltaMovement(@NotNull Vector var1);

    public void stop();

    default public void setDeltaMovement(double x, double y, double z) {
        this.setDeltaMovement(new Vector(x, y, z));
    }

    default public double getDeltaMovementX() {
        return this.getDeltaMovement().getX();
    }

    default public void setDeltaMovementX(double x) {
        this.setDeltaMovement(new Vector(x, this.getDeltaMovementY(), this.getDeltaMovementZ()));
    }

    default public double getDeltaMovementY() {
        return this.getDeltaMovement().getY();
    }

    default public void setDeltaMovementY(double y) {
        this.setDeltaMovement(new Vector(this.getDeltaMovementX(), y, this.getDeltaMovementZ()));
    }

    default public double getDeltaMovementZ() {
        return this.getDeltaMovement().getZ();
    }

    default public void setDeltaMovementZ(double z) {
        this.setDeltaMovement(new Vector(this.getDeltaMovementX(), this.getDeltaMovementY(), z));
    }
}

