/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.abstraction.v1_21_R4;

import be.isach.ultracosmetics.shaded.mobchip.abstraction.v1_21_R4.ChipUtil1_21_R4;
import be.isach.ultracosmetics.shaded.mobchip.abstraction.v1_21_R4.NavigationPath1_21_R4;
import be.isach.ultracosmetics.shaded.mobchip.ai.navigation.EntityNavigation;
import be.isach.ultracosmetics.shaded.mobchip.ai.navigation.NavigationPath;
import be.isach.ultracosmetics.shaded.mobchip.util.Position;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

final class EntityNavigation1_21_R4
implements EntityNavigation {
    private final NavigationAbstract handle;
    private int speedMod;
    private int range;
    private final List<Position> points;
    private final Mob m;

    public EntityNavigation1_21_R4(Mob m) {
        this.handle = ChipUtil1_21_R4.toNMS(m).N();
        this.points = new ArrayList<Position>();
        this.speedMod = 1;
        this.range = Integer.MAX_VALUE;
        this.m = m;
    }

    @Override
    public double getSpeedModifier() {
        return this.speedMod;
    }

    @Override
    public void setSpeedModifier(double mod) throws IllegalArgumentException {
        if (mod > 2.147483647E9) {
            throw new IllegalArgumentException("Must be integer");
        }
        this.speedMod = (int)Math.floor(mod);
    }

    @Override
    public EntityNavigation recompute() {
        this.handle.h();
        return this;
    }

    @Override
    public EntityNavigation addPoint(@NotNull Position point) {
        this.points.add(point);
        return this;
    }

    @Override
    public EntityNavigation addPoint(int index, @NotNull Position point) {
        this.points.add(index, point);
        return this;
    }

    @Override
    public EntityNavigation removePoint(@NotNull Position point) {
        this.points.remove(point);
        return this;
    }

    @Override
    public EntityNavigation removePoint(int index) {
        this.points.remove(index);
        return this;
    }

    private List<PathPoint> toNodes() {
        ArrayList<PathPoint> nodes = new ArrayList<PathPoint>();
        for (Position p : this.points) {
            nodes.add(new PathPoint(p.getX(), p.getY(), p.getZ()));
        }
        return nodes;
    }

    @Override
    @NotNull
    public NavigationPath buildPath() {
        if (this.points.isEmpty()) {
            throw new IllegalArgumentException("Path is empty");
        }
        return new NavigationPath1_21_R4(new PathEntity(this.toNodes(), null, true), this.m, this.speedMod);
    }

    @Override
    public EntityNavigation setRange(int range) {
        this.range = range;
        return this;
    }

    @Override
    public int getRange() {
        return this.range;
    }
}

