/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.standard;

import be.isach.ultracosmetics.shaded.kyori.adventure.key.Key;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.ObjectComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.Context;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.ParsingException;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.Tag;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.object.ObjectContents;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.object.SpriteObjectContents;
import org.jetbrains.annotations.Nullable;

final class SpriteTag {
    private static final String SPRITE = "sprite";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("sprite", SpriteTag::create, SpriteTag::claimComponent);

    private SpriteTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String secondArg;
        String firstArg = args.popOr("An atlas id and or a sprite id is required to produce a sprite object component").value();
        String string = secondArg = args.hasNext() ? args.pop().value() : null;
        if (secondArg == null) {
            return Tag.selfClosingInserting(Component.object(ObjectContents.sprite(Key.key(firstArg))));
        }
        return Tag.selfClosingInserting(Component.object(ObjectContents.sprite(Key.key(firstArg), Key.key(secondArg))));
    }

    @Nullable
    static Emitable claimComponent(Component input) {
        if (!(input instanceof ObjectComponent)) {
            return null;
        }
        ObjectContents contents = ((ObjectComponent)input).contents();
        if (!(contents instanceof SpriteObjectContents)) {
            return null;
        }
        SpriteObjectContents sprite = (SpriteObjectContents)contents;
        Key atlas = sprite.atlas();
        Key key = sprite.sprite();
        if (atlas == SpriteObjectContents.DEFAULT_ATLAS) {
            return emit -> emit.tag(SPRITE).argument(key.asString());
        }
        return emit -> emit.tag(SPRITE).argument(atlas.asString()).argument(key.asString());
    }
}

