/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.run;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.task.UltraTask;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VanishChecker
extends UltraTask {
    private final UltraCosmetics ultraCosmetics;
    private final UltraPlayerManager pm;

    public VanishChecker(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.pm = ultraCosmetics.getPlayerManager();
    }

    @Override
    public void run() {
        for (UltraPlayer ultraPlayer : this.pm.getUltraPlayers()) {
            Player player = ultraPlayer.getBukkitPlayer();
            if (player == null || !PlayerAffectingCosmetic.isVanished(player) || !ultraPlayer.hasCosmeticsEquipped()) continue;
            MessageManager.send((CommandSender)player, "Not-Allowed-In-Vanish", new TagResolver.Single[0]);
            this.ultraCosmetics.getScheduler().runAtEntity((Entity)player, t -> ultraPlayer.clear());
        }
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runTimerAsync(this::run, 100L, 100L);
    }
}

