/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player.profile;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.mysql.MySqlConnectionManager;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.player.profile.ProfileKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerData {
    private UUID uuid;
    private int keys;
    private boolean gadgetsEnabled;
    private boolean morphSelfView;
    private boolean treasureNotifications;
    private boolean filterByOwned;
    private Map<PetType, String> petNames = new HashMap<PetType, String>();
    private Map<GadgetType, Integer> ammo = new HashMap<GadgetType, Integer>();
    private Map<Category, CosmeticType<?>> enabledCosmetics = new HashMap();
    private Set<CosmeticType<?>> unlockedCosmetics = new HashSet();

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getKeys() {
        return this.keys;
    }

    public void setKeys(int keys) {
        this.keys = keys;
    }

    public boolean isGadgetsEnabled() {
        return this.gadgetsEnabled;
    }

    public void setGadgetsEnabled(boolean gadgetsEnabled) {
        this.gadgetsEnabled = gadgetsEnabled;
    }

    public boolean isMorphSelfView() {
        return this.morphSelfView;
    }

    public void setMorphSelfView(boolean morphSelfView) {
        this.morphSelfView = morphSelfView;
    }

    public boolean isTreasureNotifications() {
        return this.treasureNotifications;
    }

    public void setTreasureNotifications(boolean treasureNotifications) {
        this.treasureNotifications = treasureNotifications;
    }

    public boolean isFilterByOwned() {
        return this.filterByOwned;
    }

    public void setFilterByOwned(boolean filterByOwned) {
        this.filterByOwned = filterByOwned;
    }

    public Map<PetType, String> getPetNames() {
        return this.petNames;
    }

    public Map<GadgetType, Integer> getAmmo() {
        return this.ammo;
    }

    public Map<Category, CosmeticType<?>> getEnabledCosmetics() {
        return this.enabledCosmetics;
    }

    public Set<CosmeticType<?>> getUnlockedCosmetics() {
        return this.unlockedCosmetics;
    }

    public void loadFromFile() {
        SettingsManager sm = SettingsManager.getData(this.uuid);
        if (UltraCosmeticsData.get().areCosmeticsProfilesEnabled() && sm.fileConfiguration.isConfigurationSection("enabled")) {
            this.loadEquippedFromFile(sm);
        }
        for (CosmeticType<?> pet : CosmeticType.enabledOf(Category.PETS)) {
            String name = sm.getString(ProfileKey.PET_NAMES.getFileKey() + "." + pet.getConfigName());
            if (name == null) continue;
            this.petNames.put((PetType)pet, name);
        }
        for (CosmeticType<?> gadget : CosmeticType.enabledOf(Category.GADGETS)) {
            this.ammo.put((GadgetType)gadget, sm.getInt(ProfileKey.AMMO.getFileKey() + "." + gadget.getConfigName().toLowerCase(Locale.ROOT)));
        }
        for (String value : sm.getStringList(ProfileKey.UNLOCKED.getFileKey())) {
            String[] parts = value.split(":");
            Category cat = Category.valueOf(parts[0]);
            CosmeticType<?> type = cat.valueOfType(parts[1]);
            if (type == null) continue;
            this.unlockedCosmetics.add(type);
        }
        this.keys = sm.getInt(ProfileKey.KEYS.getFileKey());
        this.gadgetsEnabled = sm.getBoolean(ProfileKey.GADGETS_ENABLED.getFileKey(), true);
        this.morphSelfView = sm.getBoolean(ProfileKey.MORPH_VIEW.getFileKey(), true);
        this.treasureNotifications = sm.getBoolean(ProfileKey.TREASURE_NOTIFICATION.getFileKey(), true);
        this.filterByOwned = sm.getBoolean(ProfileKey.FILTER_OWNED.getFileKey(), false);
    }

    private void loadEquippedFromFile(SettingsManager sm) {
        ConfigurationSection s = sm.fileConfiguration.getConfigurationSection("enabled");
        boolean changed = false;
        for (Category cat : Category.values()) {
            CosmeticType<?> cosmetic;
            String value;
            String key = cat.toString().toLowerCase(Locale.ROOT);
            String oldKey = key.substring(0, key.length() - 1);
            if (s.isString(oldKey)) {
                value = s.getString(oldKey);
                s.set(key, (Object)value);
                s.set(oldKey, null);
                changed = true;
            } else {
                value = s.getString(key);
            }
            if (value == null || value.equals("none") || (cosmetic = cat.valueOfType(value)) == null) continue;
            this.enabledCosmetics.put(cat, cosmetic);
        }
        if (changed) {
            sm.save();
        }
    }

    public void saveToFile() {
        SettingsManager data = SettingsManager.getData(this.uuid);
        data.set(ProfileKey.KEYS.getFileKey(), this.keys);
        data.set(ProfileKey.GADGETS_ENABLED.getFileKey(), this.gadgetsEnabled);
        data.set(ProfileKey.MORPH_VIEW.getFileKey(), this.morphSelfView);
        data.set(ProfileKey.TREASURE_NOTIFICATION.getFileKey(), this.treasureNotifications);
        data.set(ProfileKey.FILTER_OWNED.getFileKey(), this.filterByOwned);
        for (Category category : Category.enabled()) {
            CosmeticType<?> type = this.enabledCosmetics.get((Object)category);
            data.set("enabled." + category.toString().toLowerCase(Locale.ROOT), type == null ? null : type.getConfigName().toLowerCase(Locale.ROOT));
        }
        for (Map.Entry entry : this.petNames.entrySet()) {
            data.set(ProfileKey.PET_NAMES.getFileKey() + "." + ((PetType)entry.getKey()).getConfigName(), entry.getValue());
        }
        for (Map.Entry entry : this.ammo.entrySet()) {
            Integer amount = (Integer)entry.getValue();
            if (amount != null && amount == 0) {
                amount = null;
            }
            data.set(ProfileKey.AMMO.getFileKey() + "." + ((GadgetType)entry.getKey()).getConfigName().toLowerCase(Locale.ROOT), amount);
        }
        ArrayList unlocked = new ArrayList();
        this.unlockedCosmetics.forEach(k -> unlocked.add(String.valueOf((Object)k.getCategory()) + ":" + k.getConfigName()));
        data.set(ProfileKey.UNLOCKED.getFileKey(), unlocked);
        data.save();
    }

    public void loadFromSQL() {
        UltraCosmeticsData data = UltraCosmeticsData.get();
        MySqlConnectionManager sql = data.getPlugin().getMySqlConnectionManager();
        PlayerDataTable pd = sql.getPlayerData();
        pd.addPlayer(this.uuid);
        Map<String, Object> settings = pd.getSettings(this.uuid);
        this.gadgetsEnabled = (Boolean)settings.get(ProfileKey.GADGETS_ENABLED.getSqlKey());
        this.morphSelfView = (Boolean)settings.get(ProfileKey.MORPH_VIEW.getSqlKey());
        this.treasureNotifications = (Boolean)settings.get(ProfileKey.TREASURE_NOTIFICATION.getSqlKey());
        this.filterByOwned = (Boolean)settings.get(ProfileKey.FILTER_OWNED.getSqlKey());
        this.keys = (Integer)settings.get(ProfileKey.KEYS.getSqlKey());
        if (sql.getPetNames() != null) {
            this.petNames = sql.getPetNames().getAllPetNames(this.uuid);
        }
        if (sql.getAmmoTable() != null) {
            this.ammo = sql.getAmmoTable().getAllAmmo(this.uuid);
        }
        if (sql.getEquippedTable() != null) {
            this.enabledCosmetics = sql.getEquippedTable().getEquipped(this.uuid);
        }
        if (sql.getUnlockedTable() != null) {
            this.unlockedCosmetics = sql.getUnlockedTable().getAllUnlocked(this.uuid);
        }
    }

    public void saveToSQL() {
        MySqlConnectionManager sql = UltraCosmeticsData.get().getPlugin().getMySqlConnectionManager();
        PlayerDataTable pd = sql.getPlayerData();
        pd.addPlayer(this.uuid);
        pd.setKeys(this.uuid, this.keys);
        pd.setSetting(this.uuid, ProfileKey.GADGETS_ENABLED, this.gadgetsEnabled);
        pd.setSetting(this.uuid, ProfileKey.MORPH_VIEW, this.morphSelfView);
        pd.setSetting(this.uuid, ProfileKey.TREASURE_NOTIFICATION, this.treasureNotifications);
        pd.setSetting(this.uuid, ProfileKey.FILTER_OWNED, this.filterByOwned);
        if (sql.getPetNames() != null) {
            sql.getPetNames().setAllPetNames(this.uuid, this.petNames);
        }
        if (sql.getAmmoTable() != null) {
            sql.getAmmoTable().setAllAmmo(this.uuid, this.ammo);
        }
        if (sql.getEquippedTable() != null) {
            sql.getEquippedTable().setAllEquipped(this.uuid, this.enabledCosmetics);
        }
        if (sql.getUnlockedTable() != null) {
            sql.getUnlockedTable().setAllUnlocked(this.uuid, this.unlockedCosmetics);
        }
    }
}

