/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.permissions;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.permissions.BukkitPermissionGetter;
import be.isach.ultracosmetics.permissions.CosmeticPermissionGetter;
import be.isach.ultracosmetics.permissions.CosmeticPermissionSetter;
import be.isach.ultracosmetics.permissions.GrantSource;
import be.isach.ultracosmetics.permissions.LuckPermsHook;
import be.isach.ultracosmetics.permissions.PermissionCommand;
import be.isach.ultracosmetics.permissions.ProfileBukkitHybridGetter;
import be.isach.ultracosmetics.permissions.ProfilePermissions;
import be.isach.ultracosmetics.permissions.RawPermissionGetter;
import be.isach.ultracosmetics.permissions.RawPermissionSetter;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PermissionManager {
    private CosmeticPermissionGetter cosmeticGetter;
    private RawPermissionGetter rawGetter;
    private CosmeticPermissionSetter cosmeticSetter;
    private RawPermissionSetter rawSetter;

    public PermissionManager(UltraCosmetics ultraCosmetics) {
        BukkitPermissionGetter bukkit = new BukkitPermissionGetter();
        PermissionCommand cmd = new PermissionCommand();
        CustomConfiguration config = SettingsManager.getConfig();
        String pma = config.getString("TreasureChests.Permission-Add-Command", "");
        if (pma.startsWith("!lp-api")) {
            if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
                LuckPermsHook lp = new LuckPermsHook(ultraCosmetics);
                this.rawSetter = lp;
                if (this.cosmeticSetter == null) {
                    this.cosmeticSetter = lp;
                }
            } else {
                ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Permission-Add-Command was set to '!lp-api' but LuckPerms is not present.");
                config.set("TreasureChests.Permission-Add-Command", "");
                pma = "";
            }
        }
        if (pma.isEmpty()) {
            ProfilePermissions profile = new ProfilePermissions(ultraCosmetics);
            this.cosmeticGetter = new ProfileBukkitHybridGetter(profile, bukkit);
            this.cosmeticSetter = profile;
        }
        if (this.cosmeticGetter == null) {
            this.cosmeticGetter = bukkit;
        }
        if (this.rawGetter == null) {
            this.rawGetter = bukkit;
        }
        if (this.cosmeticSetter == null) {
            this.cosmeticSetter = cmd;
        }
        if (this.rawSetter == null) {
            this.rawSetter = cmd;
        }
    }

    public GrantSource getGrantSource(Player player, CosmeticType<?> type) {
        return this.cosmeticGetter.getGrantSource(player, type);
    }

    public boolean hasPermission(Player player, CosmeticType<?> type) {
        return this.cosmeticGetter.hasPermission(player, type);
    }

    public boolean hasPermission(UltraPlayer player, CosmeticType<?> type) {
        return this.hasPermission(player.getBukkitPlayer(), type);
    }

    public boolean hasRawPermission(Player player, String permission) {
        return this.rawGetter.hasRawPermission(player, permission);
    }

    public Set<CosmeticType<?>> getEnabledUnlocked(Player player) {
        return this.cosmeticGetter.getEnabledUnlocked(player);
    }

    public Set<CosmeticType<?>> getEnabledUnlocked(Player player, Category cat) {
        return this.cosmeticGetter.getEnabledUnlocked(player, cat);
    }

    public void setPermissions(Player player, Set<CosmeticType<?>> types) {
        this.cosmeticSetter.setPermissions(player, types);
    }

    public void unsetPermissions(Player player, Set<CosmeticType<?>> types) {
        this.cosmeticSetter.unsetPermissions(player, types);
    }

    public void setPermission(Player player, CosmeticType<?> type) {
        HashSet types = new HashSet();
        types.add(type);
        this.setPermissions(player, types);
    }

    public void unsetPermission(Player player, CosmeticType<?> type) {
        HashSet types = new HashSet();
        types.add(type);
        this.unsetPermissions(player, types);
    }

    public void setPermission(UltraPlayer player, CosmeticType<?> type) {
        this.setPermission(player.getBukkitPlayer(), type);
    }

    public void setRawPermission(Player player, String permission) {
        this.rawSetter.setRawPermission(player, permission);
    }

    public boolean isUsingProfile() {
        return this.cosmeticGetter instanceof ProfilePermissions;
    }

    public boolean isUnsetSupported() {
        return this.cosmeticSetter.isUnsetSupported();
    }
}

