/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.UUIDColumn;
import be.isach.ultracosmetics.mysql.column.VirtualUUIDColumn;
import be.isach.ultracosmetics.mysql.tables.Table;
import be.isach.ultracosmetics.player.profile.ProfileKey;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import javax.sql.DataSource;

public class PlayerDataTable
extends Table {
    public PlayerDataTable(DataSource dataSource, String name) {
        super(dataSource, name);
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new UUIDColumn("uuid", "BINARY(16) PRIMARY KEY"));
        this.tableInfo.add(new VirtualUUIDColumn());
        this.tableInfo.add(new Column<Boolean>("gadgetsEnabled", "BOOLEAN NOT NULL DEFAULT 1", Boolean.class));
        this.tableInfo.add(new Column<Boolean>("selfMorphView", "BOOLEAN NOT NULL DEFAULT 1", Boolean.class));
        this.tableInfo.add(new Column<Boolean>("treasureNotifications", "BOOLEAN NOT NULL DEFAULT 0", Boolean.class));
        this.tableInfo.add(new Column<Boolean>("filterByOwned", "BOOLEAN NOT NULL DEFAULT 0", Boolean.class));
        this.tableInfo.add(new Column<Integer>("treasureKeys", "INTEGER NOT NULL DEFAULT 0", Integer.class));
    }

    public void addPlayer(UUID uuid) {
        this.insertIgnore("uuid").insert(PlayerDataTable.insertUUID(uuid)).execute();
    }

    public Map<String, Object> getSettings(UUID uuid) {
        StringJoiner columns = new StringJoiner(", ");
        for (ProfileKey key : ProfileKey.values()) {
            if (key.getSqlKey() == null) continue;
            columns.add(key.getSqlKey());
        }
        return this.select(columns.toString()).uuid(uuid).getResults(r -> {
            HashMap<String, Constable> settings = new HashMap<String, Constable>();
            for (ProfileKey key : ProfileKey.values()) {
                if (key.getSqlKey() == null) continue;
                if (key == ProfileKey.KEYS) {
                    settings.put(key.getSqlKey(), Integer.valueOf(r.getInt(key.getSqlKey())));
                    continue;
                }
                settings.put(key.getSqlKey(), Boolean.valueOf(r.getBoolean(key.getSqlKey())));
            }
            return settings;
        }, false);
    }

    public boolean getSetting(UUID uuid, ProfileKey key) {
        return this.select(key.getSqlKey()).uuid(uuid).asBool();
    }

    public void setSetting(UUID uuid, ProfileKey key, Object value) {
        this.update().uuid(uuid).set(key.getSqlKey(), value).execute();
    }

    public int getKeys(UUID uuid) {
        return this.select("treasureKeys").uuid(uuid).asInt();
    }

    public void setKeys(UUID uuid, int keys) {
        this.update().uuid(uuid).set("treasureKeys", keys).execute();
    }
}

