/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.StringColumn;
import be.isach.ultracosmetics.mysql.column.UniqueConstraint;
import be.isach.ultracosmetics.mysql.query.InsertQuery;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.query.SelectSubquery;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.util.Locale;
import javax.sql.DataSource;

public class CosmeticTable
extends Table {
    public CosmeticTable(DataSource dataSource, String name) {
        super(dataSource, name);
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new Column<Integer>("id", "INTEGER AUTO_INCREMENT PRIMARY KEY", Integer.class));
        this.tableInfo.add(new StringColumn("category", 32, true));
        this.tableInfo.add(new StringColumn("type", 32, true));
        this.tableInfo.add(new UniqueConstraint("category", "type"));
        this.tableInfo.add(new UniqueConstraint("id", "category"));
    }

    @Override
    public void loadBaseData() {
        InsertQuery insert = this.insertIgnore("category", "type");
        for (Category cat : Category.values()) {
            InsertValue catItem = new InsertValue(cat.toString().toLowerCase(Locale.ROOT));
            for (CosmeticType<?> type : cat.getValues()) {
                insert.insert(catItem, new InsertValue(type.getConfigName().toLowerCase(Locale.ROOT)));
            }
        }
        insert.execute();
    }

    public SelectSubquery subqueryFor(CosmeticType<?> type, boolean insert) {
        return new SelectSubquery(insert ? null : "id", this.getWrappedName(), "id").where("category", CosmeticTable.cleanCategoryName(type)).where("type", CosmeticTable.cleanCosmeticName(type));
    }

    public int getCosmeticID(CosmeticType<?> type) {
        return this.select("id").where("category", CosmeticTable.cleanCategoryName(type)).where("type", CosmeticTable.cleanCosmeticName(type)).asInt();
    }
}

