/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.query;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.mysql.query.InsertItem;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.query.StandardQuery;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class InsertQuery {
    private final List<InsertItem[]> inserts = new ArrayList<InsertItem[]>();
    private final Table table;
    private final boolean ignore;
    private final String[] columns;
    private boolean updateOnDuplicate = false;

    public InsertQuery(Table table, boolean ignore, String ... columns) {
        this.table = table;
        this.ignore = ignore;
        this.columns = columns;
    }

    public InsertQuery(Table table, String ... columns) {
        this(table, false, columns);
    }

    public InsertQuery insert(InsertItem ... item) {
        if (item.length != this.columns.length) {
            throw new IllegalArgumentException("Must have a value for every inserted column");
        }
        this.inserts.add(item);
        return this;
    }

    public InsertQuery insert(String ... values) {
        InsertItem[] items = new InsertValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            items[i] = new InsertValue(values[i]);
        }
        return this.insert(items);
    }

    public InsertQuery updateOnDuplicate() {
        this.updateOnDuplicate = true;
        return this;
    }

    public void execute() {
        if (this.inserts.isEmpty()) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Skipping query to " + this.table.getClass().getSimpleName() + " as no values were specified.");
            return;
        }
        StringBuilder sql = new StringBuilder("INSERT ");
        if (this.ignore) {
            sql.append("IGNORE ");
        }
        sql.append("INTO ").append(this.table.getWrappedName()).append(" ");
        ArrayList<Object> objects = new ArrayList<Object>();
        StringJoiner columns = new StringJoiner(", ", "(", ")");
        for (String col : this.columns) {
            columns.add(col);
        }
        StringJoiner values = new StringJoiner(",");
        for (InsertItem[] items : this.inserts) {
            StringJoiner sj = new StringJoiner(", ", "(", ")");
            for (InsertItem item : items) {
                sj.add(item.toSQL(objects));
            }
            values.add(sj.toString());
        }
        sql.append(columns).append(" VALUES ").append(values);
        if (this.updateOnDuplicate) {
            sql.append(" ON DUPLICATE KEY UPDATE ");
            StringJoiner update = new StringJoiner(", ");
            for (String col : this.columns) {
                update.add(col + "=VALUES(" + col + ")");
            }
            sql.append(update);
        }
        StandardQuery.printStringified(sql, objects);
        try (Connection connection = this.table.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int i = 0; i < objects.size(); ++i) {
                statement.setObject(i + 1, objects.get(i));
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

