/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.Menu;
import be.isach.ultracosmetics.menu.buttons.ClearCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.CommandButton;
import be.isach.ultracosmetics.menu.buttons.KeysButton;
import be.isach.ultracosmetics.menu.buttons.OpenChestButton;
import be.isach.ultracosmetics.menu.buttons.OpenCosmeticMenuButton;
import be.isach.ultracosmetics.menu.buttons.RenamePetButton;
import be.isach.ultracosmetics.menu.buttons.ToggleGadgetsButton;
import be.isach.ultracosmetics.menu.buttons.ToggleMorphSelfViewButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.SmartLogger;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;

public class CustomMainMenu
extends Menu {
    private final File customMenuFile;
    private final YamlConfiguration config = new YamlConfiguration();
    private final Component title = MessageManager.getMessage("Menu.Main.Title", new TagResolver.Single[0]);

    public CustomMainMenu(UltraCosmetics ultraCosmetics) {
        super("main", ultraCosmetics);
        this.customMenuFile = CustomMainMenu.getFile(ultraCosmetics);
        try {
            this.config.load(this.customMenuFile);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnabled() {
        return this.config.getBoolean("Enabled");
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer player) {
        ConfigurationSection slots = this.config.getConfigurationSection("Slots");
        boolean saveRequired = false;
        block26: for (String key : slots.getKeys(false)) {
            Button button;
            int slot;
            try {
                slot = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Non-numeric key in main menu config: '" + key + "'");
                continue;
            }
            if (slot < 0 || slot >= this.getSize()) {
                this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Slot index out of range 0-" + this.getSize() + ": " + slot);
                continue;
            }
            ConfigurationSection section = slots.getConfigurationSection(key);
            String typeName = section.getString("Type", "");
            switch (typeName.toLowerCase(Locale.ROOT)) {
                case "command": {
                    try {
                        if (section.isString("Material")) {
                            saveRequired = true;
                        }
                        button = CommandButton.deserialize(section, this.ultraCosmetics);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, e.getMessage());
                        continue block26;
                    }
                }
                case "clearcosmetic": {
                    button = new ClearCosmeticButton();
                    break;
                }
                case "keys": {
                    button = new KeysButton(this.ultraCosmetics);
                    break;
                }
                case "openchest": {
                    button = new OpenChestButton(this.ultraCosmetics);
                    break;
                }
                case "opencosmeticmenu": {
                    String targetName = slots.getString(key + ".Menu", "");
                    Category target = targetName.equalsIgnoreCase("suits") ? Category.SUITS_HELMET : Category.fromString(targetName);
                    if (target == null) {
                        this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Unknown target menu: " + targetName);
                        continue block26;
                    }
                    button = new OpenCosmeticMenuButton(this.ultraCosmetics, target);
                    break;
                }
                case "renamepet": {
                    button = new RenamePetButton(this.ultraCosmetics);
                    break;
                }
                case "togglegadgets": {
                    button = new ToggleGadgetsButton();
                    break;
                }
                case "togglemorphselfview": {
                    button = new ToggleMorphSelfViewButton();
                    break;
                }
                default: {
                    this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Unknown button type: '" + typeName + "'");
                    continue block26;
                }
            }
            this.putItem(inventory, slot, button, player);
        }
        if (saveRequired) {
            try {
                this.config.save(this.customMenuFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int getSize() {
        return this.config.getInt("Size", 54);
    }

    @Override
    protected Component getName() {
        return this.title;
    }

    public static File getFile(UltraCosmetics ultraCosmetics) {
        return new File(ultraCosmetics.getDataFolder(), "custom_main_menu.yml");
    }
}

