/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons.togglecosmetic;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.menu.buttons.CosmeticButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ToggleCosmeticButton
extends CosmeticButton {
    private final boolean showPermissionInLore = SettingsManager.getConfig().getBoolean("No-Permission.Show-In-Lore");
    private final Component permissionYes = MessageManager.getMessage("Permission-Lore.Permission-Yes", new TagResolver.Single[0]);
    private final Component permissionNo = MessageManager.getMessage("Permission-Lore.Permission-No", new TagResolver.Single[0]);
    private final Component permissionShowroom = MessageManager.getMessage("Permission-Lore.Showroom", new TagResolver.Single[0]);

    public ToggleCosmeticButton(UltraCosmetics ultraCosmetics, CosmeticType<?> cosmeticType) {
        super(ultraCosmetics, cosmeticType, false);
    }

    @Override
    protected ItemStack getBaseItem(UltraPlayer ultraPlayer) {
        boolean deactivate;
        Component toggle = this.cosmeticType.getCategory().getActivateTooltip();
        boolean bl = deactivate = ultraPlayer.hasCosmetic(this.cosmeticType.getCategory()) && ultraPlayer.getCosmetic(this.cosmeticType.getCategory()).getType() == this.cosmeticType;
        if (deactivate) {
            toggle = this.cosmeticType.getCategory().getDeactivateTooltip();
        }
        Component name = ((TextComponent)((TextComponent)Component.empty().append(toggle)).appendSpace()).append(this.cosmeticType.getName());
        name = this.modifyName(name, ultraPlayer);
        ItemStack stack = ItemFactory.rename(this.cosmeticType.getItemStack(), name, new String[0]);
        if (deactivate) {
            ItemFactory.addGlow(stack);
        }
        ItemMeta meta = stack.getItemMeta();
        ArrayList<String> loreList = new ArrayList<String>();
        if (this.cosmeticType.showsDescription()) {
            loreList.add("");
            loreList.addAll(this.cosmeticType.getDescription());
        }
        this.modifyLore(loreList, ultraPlayer);
        if (this.showPermissionInLore) {
            loreList.add("");
            Component permissionLore = this.ultraCosmetics.getPermissionManager().hasPermission(ultraPlayer, this.cosmeticType) ? this.permissionYes : (this.ultraCosmetics.getWorldGuardManager().isInShowroom(ultraPlayer.getBukkitPlayer()) ? this.permissionShowroom : this.permissionNo);
            loreList.add(MessageManager.toLegacy(permissionLore));
        }
        meta.setLore(loreList);
        meta = this.modifyMeta(meta, ultraPlayer);
        stack.setItemMeta(meta);
        stack.setAmount(this.getAmount(ultraPlayer));
        return stack;
    }

    protected Component modifyName(Component base, UltraPlayer ultraPlayer) {
        return base;
    }

    protected void modifyLore(List<String> lore, UltraPlayer ultraPlayer) {
    }

    protected ItemMeta modifyMeta(ItemMeta meta, UltraPlayer ultraPlayer) {
        return meta;
    }

    protected int getAmount(UltraPlayer ultraPlayer) {
        return 1;
    }
}

