/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.buttons.TreasureButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.treasurechests.TreasureRandomizer;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class OpenChestButton
extends TreasureButton {
    private final Component itemName = MessageManager.getMessage("Treasure-Chests", new TagResolver.Single[0]);
    private final String chestMode = SettingsManager.getConfig().getString("TreasureChests.Mode", "structure");
    private final int chestCount = SettingsManager.getConfig().getInt("TreasureChests.Count", 4);
    private final String[] noKeysLore = new String[]{"", MessageManager.getLegacyMessage("Dont-Have-Key", new TagResolver.Single[0]), this.buyKeyMessage};
    private final String[] hasKeysLore;
    private final TreasureChestManager treasureChestManager;
    private final XSound.SoundPlayer noKeysSound;

    public OpenChestButton(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics);
        this.treasureChestManager = ultraCosmetics.getTreasureChestManager();
        this.hasKeysLore = this.chestMode.equalsIgnoreCase("both") ? new String[]{"", MessageManager.getLegacyMessage("Left-Click-Open-Chest", new TagResolver.Single[0]), MessageManager.getLegacyMessage("Right-Click-Simple", new TagResolver.Single[0]), ""} : new String[]{"", MessageManager.getLegacyMessage("Click-Open-Chest", new TagResolver.Single[0]), ""};
        this.noKeysSound = XSound.BLOCK_ANVIL_LAND.record().withVolume(0.2f).withPitch(1.2f).soundPlayer();
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        String[] lore = ultraPlayer.getKeys() < 1 ? this.noKeysLore : this.hasKeysLore;
        return ItemFactory.create(XMaterial.CHEST, this.itemName, lore);
    }

    @Override
    public void onClick(ClickData clickData) {
        UltraPlayer player = clickData.getClicker();
        Player p = player.getBukkitPlayer();
        if (!this.canBuyKeys && player.getKeys() < 1) {
            this.noKeysSound.forPlayers(new Player[]{p}).play();
            return;
        }
        String selectedMode = this.chestMode;
        if (this.chestMode.equalsIgnoreCase("both")) {
            selectedMode = clickData.getClick().isRightClick() ? "simple" : "structure";
        }
        if (player.getKeys() > 0 && selectedMode.equalsIgnoreCase("simple")) {
            player.removeKey();
            TreasureRandomizer tr = new TreasureRandomizer(p, p.getLocation().subtract(1.0, 0.0, 1.0), true);
            for (int i = 0; i < this.chestCount; ++i) {
                tr.giveRandomThing(null, false);
            }
            clickData.getMenu().open(player);
        } else {
            this.treasureChestManager.tryOpenChest(p);
        }
    }
}

