/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.menu.buttons.CosmeticButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.MiniMessage;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CosmeticNoPermissionButton
extends CosmeticButton {
    private final String name;
    private final List<String> lore = new ArrayList<String>();
    private final ItemStack stack = ItemFactory.getItemStackFromConfig("No-Permission.Custom-Item.Type");

    public CosmeticNoPermissionButton(UltraCosmetics ultraCosmetics, CosmeticType<?> cosmeticType) {
        super(ultraCosmetics, cosmeticType, true);
        MiniMessage mm = MessageManager.getMiniMessage();
        String rawName = SettingsManager.getConfig().getString("No-Permission.Custom-Item.Name", "");
        this.name = MessageManager.toLegacy(mm.deserialize(rawName, (TagResolver)Placeholder.component("cosmetic", cosmeticType.getName())));
        List<String> rawLore = SettingsManager.getConfig().isList("No-Permission.Custom-Item.Lore") ? SettingsManager.getConfig().getStringList("No-Permission.Custom-Item.Lore") : Arrays.asList(SettingsManager.getConfig().getString("No-Permission.Custom-Item.Lore", "").split("\n"));
        for (String item : rawLore) {
            if (item.equalsIgnoreCase("<description>")) {
                this.lore.addAll(cosmeticType.getDescription());
                continue;
            }
            this.lore.add(MessageManager.toLegacy(mm.deserialize(item)));
        }
    }

    @Override
    public ItemStack getBaseItem(UltraPlayer ultraPlayer) {
        ItemStack stack = this.stack.clone();
        ItemFactory.rename(stack, this.name, new String[0]);
        ItemMeta meta = stack.getItemMeta();
        meta.setLore(this.lore);
        stack.setItemMeta(meta);
        return stack;
    }
}

