/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CommandButton
implements Button {
    private final ItemStack stack;
    private final String command;
    private final boolean closeAfterClick;

    public CommandButton(ItemStack stack, String command, boolean closeAfterClick) {
        this.stack = stack;
        this.command = command;
        this.closeAfterClick = closeAfterClick;
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        return this.stack;
    }

    @Override
    public void onClick(ClickData clickData) {
        if (this.closeAfterClick) {
            clickData.getClicker().getBukkitPlayer().closeInventory();
        }
        if (this.command == null) {
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.command.replace("%player%", clickData.getClicker().getBukkitPlayer().getName()));
    }

    private static void migrate(ConfigurationSection section) {
        ConfigurationSection item = section.createSection("item");
        BiConsumer<String, String> migrate = (before, after) -> {
            item.set(after, section.get(before));
            section.set(before, null);
        };
        migrate.accept("Material", "material");
        migrate.accept("Amount", "amount");
        migrate.accept("Name", "name");
        migrate.accept("Lore", "lore");
        migrate.accept("CustomModelData", "custom-model-data");
    }

    public static CommandButton deserialize(ConfigurationSection section, UltraCosmetics ultraCosmetics) {
        if (section.isString("Material")) {
            CommandButton.migrate(section);
        }
        if (!section.isConfigurationSection("item")) {
            throw new IllegalArgumentException("No item defined");
        }
        ItemStack stack = ItemFactory.parseXItemStack(section.getConfigurationSection("item"));
        boolean closeAfterClick = section.getBoolean("CloseAfterClick");
        String command = section.getString("Command");
        return new CommandButton(stack, command, closeAfterClick);
    }
}

