/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import org.bukkit.inventory.ItemStack;

public class ClearCosmeticButton
implements Button {
    private final ItemStack stack;
    private final Category category;

    public ClearCosmeticButton(Category category) {
        this.category = category;
        this.stack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Categories.Clear-Cosmetic-Item"), MessageManager.getMessage("Clear." + (category == null ? "Cosmetics" : category.getConfigPath()), new TagResolver.Single[0]), new String[0]);
    }

    public ClearCosmeticButton() {
        this(null);
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        return this.stack;
    }

    @Override
    public void onClick(ClickData clickData) {
        UltraPlayer clicker = clickData.getClicker();
        if (this.category == null) {
            clicker.clear();
            return;
        }
        if (this.category.isSuits()) {
            for (Category cat : Category.values()) {
                if (!cat.isSuits()) continue;
                clicker.removeCosmetic(cat);
            }
        } else {
            clicker.removeCosmetic(this.category);
        }
        clickData.getMenu().refresh(clicker);
    }
}

