/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.listeners;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextDecoration;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    private final UltraCosmetics ultraCosmetics;
    private final UltraPlayerManager pm;
    private final ItemStack menuItem;
    private final boolean menuItemEnabled = SettingsManager.getConfig().getBoolean("Menu-Item.Enabled");
    private final int menuItemSlot = SettingsManager.getConfig().getInt("Menu-Item.Slot");
    private final long joinItemDelay = SettingsManager.getConfig().getLong("Item-Delay.Join", 1L);
    private final long respawnItemDelay = SettingsManager.getConfig().getLong("Item-Delay.World-Change-Or-Respawn", 0L);
    private final boolean updateOnWorldChange = SettingsManager.getConfig().getBoolean("Always-Update-Cosmetics-On-World-Change", false);
    private final boolean preventCommandsDuringChests = SettingsManager.getConfig().getBoolean("TreasureChests.Prevent-Commands-While-Opening", false);

    public PlayerListener(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.pm = ultraCosmetics.getPlayerManager();
        this.menuItem = ItemFactory.getMenuItem();
    }

    private boolean isNPC(Player player) {
        return player.hasMetadata("NPC") || player.hasMetadata("fake-player");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreJoin(PlayerJoinEvent event) {
        if (this.isNPC(event.getPlayer())) {
            return;
        }
        this.pm.createUltraPlayer(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.isNPC(event.getPlayer())) {
            return;
        }
        UltraPlayer ultraPlayer = this.pm.getUltraPlayer(event.getPlayer());
        if (SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
            this.runWhenValid(event.getPlayer(), this.joinItemDelay, ultraPlayer::load);
        }
        if (this.ultraCosmetics.getUpdateChecker() != null && this.ultraCosmetics.getUpdateChecker().isOutdated() && event.getPlayer().hasPermission("ultracosmetics.updatenotify")) {
            Component prefix = MessageManager.getMessage("Prefix", new TagResolver.Single[0]);
            ultraPlayer.sendMessage(((TextComponent)Component.empty().append(prefix)).append(Component.text("An update is available: " + String.valueOf(this.ultraCosmetics.getUpdateChecker().getSpigotVersion()), (TextColor)NamedTextColor.RED, TextDecoration.BOLD)));
            TextComponent use = Component.text("Use ", (TextColor)NamedTextColor.RED, TextDecoration.BOLD);
            TextComponent command = Component.text("/uc update", (TextColor)NamedTextColor.YELLOW);
            TextComponent toInstall = Component.text(" to install the update.", (TextColor)NamedTextColor.RED, TextDecoration.BOLD);
            ultraPlayer.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.empty().append(prefix)).append(use)).append(command)).append(toInstall));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (this.isNPC(event.getPlayer())) {
            return;
        }
        if (!SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
            return;
        }
        UltraPlayer up = this.pm.getUltraPlayer(event.getPlayer());
        if (this.menuItemEnabled && event.getPlayer().hasPermission("ultracosmetics.receivechest")) {
            this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)event.getPlayer(), up::giveMenuItem, this.respawnItemDelay);
        }
        if (!SettingsManager.isAllowedWorld(event.getFrom()) || this.updateOnWorldChange) {
            this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)event.getPlayer(), () -> up.getProfile().equip(), this.respawnItemDelay);
        }
    }

    private void clearCosmeticsForWorldChange(Player player) {
        boolean goingToBadWorld;
        if (this.isNPC(player)) {
            return;
        }
        boolean bl = goingToBadWorld = !SettingsManager.isAllowedWorld(player.getWorld());
        if (!goingToBadWorld && !this.updateOnWorldChange) {
            return;
        }
        UltraPlayer ultraPlayer = this.pm.getUltraPlayer(player);
        ultraPlayer.removeMenuItem();
        ultraPlayer.withPreserveEquipped(() -> {
            if (ultraPlayer.clear() && goingToBadWorld) {
                MessageManager.send((CommandSender)ultraPlayer.getBukkitPlayer(), "World-Disabled", new TagResolver.Single[0]);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChangeEarly(PlayerChangedWorldEvent event) {
        this.clearCosmeticsForWorldChange(event.getPlayer());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getTo() != null && event.getFrom().getWorld() != event.getTo().getWorld()) {
            this.clearCosmeticsForWorldChange(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent event) {
        if (this.isNPC(event.getPlayer())) {
            return;
        }
        this.runWhenValid(event.getPlayer(), Math.max(1L, this.respawnItemDelay), () -> {
            if (!SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
                return;
            }
            UltraPlayer ultraPlayer = this.pm.getUltraPlayer(event.getPlayer());
            if (this.menuItemEnabled) {
                ultraPlayer.giveMenuItem();
            }
            ultraPlayer.getProfile().equip();
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.pm.getUltraPlayer(event.getPlayer()).dispose();
        UUID uuid = event.getPlayer().getUniqueId();
        this.ultraCosmetics.getScheduler().runLater(() -> this.pm.remove(uuid), 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(PlayerDeathEvent event) {
        UltraPlayer ultraPlayer;
        if (this.isNPC(event.getEntity())) {
            return;
        }
        if (this.isMenuItem(event.getEntity().getInventory().getItem(this.menuItemSlot))) {
            event.getDrops().remove(event.getEntity().getInventory().getItem(this.menuItemSlot));
            event.getEntity().getInventory().setItem(this.menuItemSlot, null);
        }
        if ((ultraPlayer = this.pm.getUltraPlayer(event.getEntity())).getCurrentGadget() != null) {
            event.getDrops().remove(ultraPlayer.getCurrentGadget().getItemStack());
        }
        if (ultraPlayer.getCurrentHat() != null) {
            event.getDrops().remove(ultraPlayer.getCurrentHat().getItemStack());
        }
        Arrays.asList(ArmorSlot.values()).forEach(armorSlot -> {
            if (ultraPlayer.getCurrentSuit((ArmorSlot)((Object)armorSlot)) != null) {
                event.getDrops().remove(ultraPlayer.getCurrentSuit((ArmorSlot)((Object)armorSlot)).getItemStack());
            }
        });
        if (ultraPlayer.getCurrentEmote() != null) {
            event.getDrops().remove(ultraPlayer.getCurrentEmote().getItemStack());
        }
        ultraPlayer.withPreserveEquipped(() -> {
            for (Category cat : Category.values()) {
                if (!cat.isClearOnDeath()) continue;
                ultraPlayer.removeCosmetic(cat);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && FallDamageManager.shouldBeProtected(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Firework && event.getDamager().hasMetadata("uc_firework")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickUpItem(EntityPickupItemEvent event) {
        if (this.isMenuItem(event.getItem().getItemStack())) {
            event.setCancelled(true);
            event.getItem().remove();
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (event.getPlayer().hasPermission("ultracosmetics.bypass.disabledcommands")) {
            return;
        }
        UltraPlayer player = this.pm.getUltraPlayer(event.getPlayer());
        if (this.preventCommandsDuringChests && player.getCurrentTreasureChest() != null) {
            event.setCancelled(true);
            MessageManager.send((CommandSender)event.getPlayer(), "Commands-Disabled-During-Chest", new TagResolver.Single[0]);
            return;
        }
        String strippedCommand = event.getMessage().split(" ")[0].replace("/", "").toLowerCase(Locale.ROOT);
        if (!SettingsManager.getConfig().getList("Disabled-Commands").contains(strippedCommand)) {
            return;
        }
        if (player.hasCosmeticsEquipped()) {
            event.setCancelled(true);
            MessageManager.send((CommandSender)event.getPlayer(), "Disabled-Command-Message", new TagResolver.Single[0]);
        }
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        UltraPlayer ultraPlayer = this.pm.getUltraPlayer(event.getPlayer());
        if (ultraPlayer.getCurrentGadget() != null && ultraPlayer.getCurrentGadget().getItemStack().equals((Object)event.getItem())) {
            event.setCancelled(true);
            return;
        }
        for (ArmorSlot armorSlot : ArmorSlot.values()) {
            if (ultraPlayer.getCurrentSuit(armorSlot) == null || !event.getItem().equals((Object)ultraPlayer.getCurrentSuit(armorSlot).getItemStack())) continue;
            event.setCancelled(true);
            return;
        }
    }

    private void runWhenValid(Player player, long minDelay, Runnable runnable) {
        if (player.isValid()) {
            this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)player, runnable, minDelay);
            runnable.run();
            return;
        }
        long[] counter = new long[]{0L};
        WrappedTask[] task = new WrappedTask[]{null};
        task[0] = this.ultraCosmetics.getScheduler().runTimer(() -> {
            if (player.isValid()) {
                this.ultraCosmetics.getScheduler().runAtEntity((Entity)player, t -> runnable.run());
                task[0].cancel();
                return;
            }
            long l = counter[0];
            counter[0] = l + 1L;
            if (l > 10L) {
                task[0].cancel();
            }
        }, minDelay, 1L);
    }

    private boolean isMenuItem(ItemStack item) {
        return ItemFactory.isSimilar(this.menuItem, item);
    }
}

