/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.listeners;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MainListener
implements Listener {
    private static final ParticleDisplay HEART_PARTICLES = ParticleDisplay.of((XParticle)XParticle.HEART).withCount(4).offset(0.5);
    private static final NamespacedKey PET_COOLDOWN = new NamespacedKey((Plugin)UltraCosmeticsData.get().getPlugin(), "pet_cooldown");

    @EventHandler
    public void onInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().hasMetadata("NO_INTER") || event.getRightClicked().hasMetadata("C_AD_ArmorStand")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        if (this.isPet(event.getRightClicked()) || this.isMount(event.getRightClicked())) {
            event.setCancelled(true);
            PersistentDataContainer pdc = event.getRightClicked().getPersistentDataContainer();
            Long cooldown = (Long)pdc.get(PET_COOLDOWN, PersistentDataType.LONG);
            if (cooldown != null && cooldown > System.currentTimeMillis()) {
                return;
            }
            boolean babies = SettingsManager.getConfig().getBoolean("Pets-Are-Babies");
            double yOffset = event.getRightClicked().getHeight();
            if (babies && event.getRightClicked() instanceof Wither) {
                yOffset = 1.0;
            }
            HEART_PARTICLES.spawn(event.getRightClicked().getLocation().add(0.0, yOffset, 0.0));
            Entity entity = event.getRightClicked();
            if (entity instanceof Mob) {
                Sound sound;
                Mob mob = (Mob)entity;
                if (!SettingsManager.getConfig().getBoolean("Pets-Are-Silent") && (sound = mob.getAmbientSound()) != null) {
                    float pitch = ThreadLocalRandom.current().nextFloat(0.8f, 1.2f);
                    if (babies) {
                        pitch += 0.5f;
                    }
                    mob.getWorld().playSound((Entity)mob, sound, 1.0f, pitch);
                }
            }
            pdc.set(PET_COOLDOWN, PersistentDataType.LONG, (Object)(System.currentTimeMillis() + 1000L));
        }
    }

    @EventHandler
    public void onDamageEntity(EntityDamageEvent event) {
        if (this.isPet(event.getEntity()) || this.isMount(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.isPet(event.getDamager()) || this.isMount(event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeashBreak(EntityUnleashEvent event) {
        if (this.isPet(event.getEntity())) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            Entity holder = entity.getLeashHolder();
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)entity, holder.getLocation());
            entity.setLeashHolder(null);
        }
    }

    @EventHandler
    public void onHopperPickup(InventoryPickupItemEvent event) {
        this.processPickup(event.getItem(), (Cancellable)event);
    }

    @EventHandler
    public void onPlayerPickup(EntityPickupItemEvent event) {
        this.processPickup(event.getItem(), (Cancellable)event);
    }

    public void processPickup(Item item, Cancellable event) {
        if (item.hasMetadata("UNPICKABLEUP")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMerge(ItemMergeEvent event) {
        if (event.getEntity().hasMetadata("UNPICKABLEUP") || event.getTarget().hasMetadata("UNPICKABLEUP")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPickup(EntityPickupItemEvent event) {
        if (this.isPet((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrowned(EntityTransformEvent event) {
        if (event.getTransformReason() == EntityTransformEvent.TransformReason.DROWNED && event.getEntity().hasMetadata("Pet")) {
            event.setCancelled(true);
            ((Zombie)event.getEntity()).setConversionTime(Integer.MAX_VALUE);
        }
    }

    @EventHandler
    public void stopDragonDamage(EntityExplodeEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (this.isPet(e) || this.isMount(e)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity e = event.getDamager();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (this.isPet(e) || this.isMount(e)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChangeBlock(EntityChangeBlockEvent event) {
        if (this.isPet(event.getEntity()) || this.isMount(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    private boolean isPet(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.hasMetadata("Pet");
    }

    private boolean isMount(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.hasMetadata("Mount");
    }
}

