/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.pets.Pet;
import be.isach.ultracosmetics.cosmetics.pets.PetAllay;
import be.isach.ultracosmetics.cosmetics.pets.PetAxolotl;
import be.isach.ultracosmetics.cosmetics.pets.PetChristmasElf;
import be.isach.ultracosmetics.cosmetics.pets.PetCreeper;
import be.isach.ultracosmetics.cosmetics.pets.PetDog;
import be.isach.ultracosmetics.cosmetics.pets.PetDonkey;
import be.isach.ultracosmetics.cosmetics.pets.PetDrowned;
import be.isach.ultracosmetics.cosmetics.pets.PetEasterBunny;
import be.isach.ultracosmetics.cosmetics.pets.PetElderGuardian;
import be.isach.ultracosmetics.cosmetics.pets.PetEnderman;
import be.isach.ultracosmetics.cosmetics.pets.PetFox;
import be.isach.ultracosmetics.cosmetics.pets.PetFrog;
import be.isach.ultracosmetics.cosmetics.pets.PetGoat;
import be.isach.ultracosmetics.cosmetics.pets.PetHoglin;
import be.isach.ultracosmetics.cosmetics.pets.PetHorse;
import be.isach.ultracosmetics.cosmetics.pets.PetIronGolem;
import be.isach.ultracosmetics.cosmetics.pets.PetKitty;
import be.isach.ultracosmetics.cosmetics.pets.PetLlama;
import be.isach.ultracosmetics.cosmetics.pets.PetMagmaCube;
import be.isach.ultracosmetics.cosmetics.pets.PetMooshroom;
import be.isach.ultracosmetics.cosmetics.pets.PetMule;
import be.isach.ultracosmetics.cosmetics.pets.PetPanda;
import be.isach.ultracosmetics.cosmetics.pets.PetParrot;
import be.isach.ultracosmetics.cosmetics.pets.PetPiglin;
import be.isach.ultracosmetics.cosmetics.pets.PetPiglinBrute;
import be.isach.ultracosmetics.cosmetics.pets.PetPufferfish;
import be.isach.ultracosmetics.cosmetics.pets.PetSheep;
import be.isach.ultracosmetics.cosmetics.pets.PetShulker;
import be.isach.ultracosmetics.cosmetics.pets.PetSkeleton;
import be.isach.ultracosmetics.cosmetics.pets.PetSlime;
import be.isach.ultracosmetics.cosmetics.pets.PetSniffer;
import be.isach.ultracosmetics.cosmetics.pets.PetSnowman;
import be.isach.ultracosmetics.cosmetics.pets.PetStray;
import be.isach.ultracosmetics.cosmetics.pets.PetTadpole;
import be.isach.ultracosmetics.cosmetics.pets.PetTropicalFish;
import be.isach.ultracosmetics.cosmetics.pets.PetTurtle;
import be.isach.ultracosmetics.cosmetics.pets.PetVex;
import be.isach.ultracosmetics.cosmetics.pets.PetVillager;
import be.isach.ultracosmetics.cosmetics.pets.PetVindicator;
import be.isach.ultracosmetics.cosmetics.pets.PetWanderingTrader;
import be.isach.ultracosmetics.cosmetics.pets.PetWarden;
import be.isach.ultracosmetics.cosmetics.pets.PetWither;
import be.isach.ultracosmetics.cosmetics.pets.PetWitherSkeleton;
import be.isach.ultracosmetics.cosmetics.pets.PetZombie;
import be.isach.ultracosmetics.cosmetics.pets.PetZombieVillager;
import be.isach.ultracosmetics.cosmetics.pets.PetZombifiedPiglin;
import be.isach.ultracosmetics.cosmetics.type.CosmeticEntType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.SmartLogger;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PetType
extends CosmeticEntType<Pet> {
    private static final Map<XEntityType, Class<? extends Pet>> PET_MAP = new HashMap<XEntityType, Class<? extends Pet>>();
    private final String customization;

    private PetType(String configName, XMaterial material, XEntityType entityType, Class<? extends Pet> clazz, String customization) {
        super(Category.PETS, configName, material, entityType, clazz);
        this.customization = customization;
        PET_MAP.putIfAbsent(entityType, clazz);
    }

    private PetType(String configName, XMaterial material, XEntityType entityType, Class<? extends Pet> clazz) {
        this(configName, material, entityType, clazz, null);
    }

    public Component getEntityName(Player player) {
        return MessageManager.getMessage("Pets." + this.getConfigName() + ".entity-displayname", Placeholder.unparsed("playername", player.getName()));
    }

    @Override
    public Component getName() {
        return MessageManager.getMessage("Pets." + this.getConfigName() + ".menu-name", new TagResolver.Single[0]);
    }

    @Override
    public Pet equip(UltraPlayer player, UltraCosmetics ultraCosmetics) {
        Pet pet = (Pet)super.equip(player, ultraCosmetics);
        if (pet != null && this.customization != null && !pet.customize(this.customization)) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Invalid customization string for pet " + this.getConfigName());
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid customization string, please contact an admin.");
        }
        return pet;
    }

    public static void registerPet(String configName, XMaterial material, XEntityType entityType, Class<? extends Pet> clazz) {
        if (!entityType.isSupported()) {
            return;
        }
        new PetType(configName, material, entityType, clazz);
    }

    public static void register() {
        ConfigurationSection pets;
        PetType.registerPet("Armadillo", XMaterial.ARMADILLO_SCUTE, XEntityType.ARMADILLO, Pet.class);
        PetType.registerPet("Piggy", XMaterial.PORKCHOP, XEntityType.PIG, Pet.class);
        PetType.registerPet("EasterBunny", XMaterial.CARROT, XEntityType.RABBIT, PetEasterBunny.class);
        PetType.registerPet("Cow", XMaterial.MILK_BUCKET, XEntityType.COW, Pet.class);
        PetType.registerPet("Mooshroom", XMaterial.RED_MUSHROOM, XEntityType.MOOSHROOM, PetMooshroom.class);
        PetType.registerPet("Dog", XMaterial.BONE, XEntityType.WOLF, PetDog.class);
        PetType.registerPet("Chick", XMaterial.EGG, XEntityType.CHICKEN, Pet.class);
        PetType.registerPet("ChristmasElf", XMaterial.BEACON, XEntityType.VILLAGER, PetChristmasElf.class);
        PetType.registerPet("IronGolem", XMaterial.IRON_INGOT, XEntityType.IRON_GOLEM, PetIronGolem.class);
        PetType.registerPet("Snowman", XMaterial.SNOWBALL, XEntityType.SNOW_GOLEM, PetSnowman.class);
        PetType.registerPet("Villager", XMaterial.EMERALD, XEntityType.VILLAGER, PetVillager.class);
        PetType.registerPet("Bat", XMaterial.COAL, XEntityType.BAT, Pet.class);
        PetType.registerPet("Sheep", XMaterial.WHITE_WOOL, XEntityType.SHEEP, PetSheep.class);
        new PetType("Wither", XMaterial.WITHER_SKELETON_SKULL, XEntityType.WITHER, PetWither.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Bossbar", (Object)"in range", "Sets who the bossbar is visible for. (Has no effect on 1.8)", "'in range': vanilla behavior, visible to all players in range.", "'owner': only visible to pet owner", "'none': not visible to any players");
            }
        };
        PetType.registerPet("Slime", XMaterial.SLIME_BALL, XEntityType.SLIME, PetSlime.class);
        PetType.registerPet("Silverfish", XMaterial.GRAY_DYE, XEntityType.SILVERFISH, Pet.class);
        PetType.registerPet("Blaze", XMaterial.BLAZE_ROD, XEntityType.BLAZE, Pet.class);
        PetType.registerPet("Creeper", XMaterial.GUNPOWDER, XEntityType.CREEPER, PetCreeper.class);
        PetType.registerPet("Enderman", XMaterial.ENDER_PEARL, XEntityType.ENDERMAN, PetEnderman.class);
        PetType.registerPet("Skeleton", XMaterial.BOW, XEntityType.SKELETON, PetSkeleton.class);
        PetType.registerPet("Zombie", XMaterial.ROTTEN_FLESH, XEntityType.ZOMBIE, PetZombie.class);
        PetType.registerPet("CaveSpider", XMaterial.SPIDER_EYE, XEntityType.CAVE_SPIDER, Pet.class);
        PetType.registerPet("Spider", XMaterial.STRING, XEntityType.SPIDER, Pet.class);
        PetType.registerPet("Endermite", XMaterial.ENDER_EYE, XEntityType.ENDERMITE, Pet.class);
        PetType.registerPet("Guardian", XMaterial.PRISMARINE_SHARD, XEntityType.GUARDIAN, Pet.class);
        PetType.registerPet("MagmaCube", XMaterial.MAGMA_CREAM, XEntityType.MAGMA_CUBE, PetMagmaCube.class);
        PetType.registerPet("Witch", XMaterial.POTION, XEntityType.WITCH, Pet.class);
        PetType.registerPet("Horse", (XMaterial)XMaterial.LEATHER_HORSE_ARMOR.or((XBase)XMaterial.LEATHER), XEntityType.HORSE, PetHorse.class);
        PetType.registerPet("Sniffer", XMaterial.TORCHFLOWER_SEEDS, XEntityType.SNIFFER, PetSniffer.class);
        PetType.registerPet("Frog", XMaterial.LILY_PAD, XEntityType.FROG, PetFrog.class);
        if (XEntityType.WARDEN.isSupported()) {
            new PetType("Warden", XMaterial.SCULK_SHRIEKER, XEntityType.WARDEN, PetWarden.class){

                @Override
                public void setupConfig(CustomConfiguration config, String path) {
                    super.setupConfig(config, path);
                    config.addDefault(path + ".Block-Effect", (Object)true, "Whether the darkness effect is blocked while this pet is equipped.", "Please note that this will also block darkness from real wardens,", "due to Spigot API limitations.");
                }
            };
        }
        PetType.registerPet("Allay", XMaterial.ALLAY_SPAWN_EGG, XEntityType.ALLAY, PetAllay.class);
        PetType.registerPet("Tadpole", XMaterial.TADPOLE_BUCKET, XEntityType.TADPOLE, PetTadpole.class);
        PetType.registerPet("Goat", (XMaterial)XMaterial.GOAT_HORN.or((XBase)XMaterial.WHEAT), XEntityType.GOAT, PetGoat.class);
        new PetType("Axolotl", XMaterial.AXOLOTL_BUCKET, XEntityType.AXOLOTL, PetAxolotl.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Fast", (Object)false, "https://imgur.com/a/EKWwQ6w");
            }
        };
        PetType.registerPet("Piglin", XMaterial.GOLD_INGOT, XEntityType.PIGLIN, PetPiglin.class);
        PetType.registerPet("Strider", XMaterial.WARPED_FUNGUS, XEntityType.STRIDER, Pet.class);
        PetType.registerPet("Hoglin", XMaterial.COOKED_PORKCHOP, XEntityType.HOGLIN, PetHoglin.class);
        PetType.registerPet("PiglinBrute", XMaterial.GOLDEN_AXE, XEntityType.PIGLIN_BRUTE, PetPiglinBrute.class);
        PetType.registerPet("Zoglin", XMaterial.ZOGLIN_SPAWN_EGG, XEntityType.ZOGLIN, Pet.class);
        PetType.registerPet("ZombifiedPiglin", XMaterial.GOLDEN_SWORD, XEntityType.ZOMBIFIED_PIGLIN, PetZombifiedPiglin.class);
        PetType.registerPet("Bee", XMaterial.HONEYCOMB, XEntityType.BEE, Pet.class);
        PetType.registerPet("Panda", XMaterial.BAMBOO, XEntityType.PANDA, PetPanda.class);
        PetType.registerPet("Fox", XMaterial.SWEET_BERRIES, XEntityType.FOX, PetFox.class);
        PetType.registerPet("Kitty", XMaterial.TROPICAL_FISH, XEntityType.CAT, PetKitty.class);
        PetType.registerPet("Ocelot", XMaterial.COD, XEntityType.OCELOT, Pet.class);
        PetType.registerPet("WanderingTrader", XMaterial.WANDERING_TRADER_SPAWN_EGG, XEntityType.WANDERING_TRADER, PetWanderingTrader.class);
        PetType.registerPet("Pillager", XMaterial.CROSSBOW, XEntityType.PILLAGER, Pet.class);
        PetType.registerPet("Ravager", XMaterial.RAVAGER_SPAWN_EGG, XEntityType.RAVAGER, Pet.class);
        PetType.registerPet("Cod", XMaterial.COD_BUCKET, XEntityType.COD, Pet.class);
        PetType.registerPet("Pufferfish", XMaterial.PUFFERFISH, XEntityType.PUFFERFISH, PetPufferfish.class);
        PetType.registerPet("Salmon", XMaterial.SALMON_BUCKET, XEntityType.SALMON, Pet.class);
        PetType.registerPet("TropicalFish", XMaterial.TROPICAL_FISH_BUCKET, XEntityType.TROPICAL_FISH, PetTropicalFish.class);
        new PetType("Turtle", XMaterial.TURTLE_HELMET, XEntityType.TURTLE, PetTurtle.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Bigger-Babies", (Object)false, "Increase the size of baby turtles. They are just so small!", "Supported on 1.20.5 or later only.");
            }
        };
        PetType.registerPet("Dolphin", XMaterial.DOLPHIN_SPAWN_EGG, XEntityType.DOLPHIN, Pet.class);
        PetType.registerPet("Drowned", XMaterial.TRIDENT, XEntityType.DROWNED, PetDrowned.class);
        PetType.registerPet("Parrot", XMaterial.COOKIE, XEntityType.PARROT, PetParrot.class);
        PetType.registerPet("Illusioner", XMaterial.COMMAND_BLOCK, XEntityType.ILLUSIONER, Pet.class);
        PetType.registerPet("Llama", XMaterial.RED_WOOL, XEntityType.LLAMA, PetLlama.class);
        PetType.registerPet("Vex", XMaterial.IRON_SWORD, XEntityType.VEX, PetVex.class);
        PetType.registerPet("Evoker", XMaterial.TOTEM_OF_UNDYING, XEntityType.EVOKER, Pet.class);
        PetType.registerPet("Vindicator", XMaterial.IRON_AXE, XEntityType.VINDICATOR, PetVindicator.class);
        PetType.registerPet("Donkey", XMaterial.CHEST, XEntityType.DONKEY, PetDonkey.class);
        PetType.registerPet("Mule", XMaterial.SADDLE, XEntityType.MULE, PetMule.class);
        PetType.registerPet("SkeletonHorse", XMaterial.BONE_BLOCK, XEntityType.SKELETON_HORSE, Pet.class);
        PetType.registerPet("ZombieHorse", XMaterial.ZOMBIE_HORSE_SPAWN_EGG, XEntityType.ZOMBIE_HORSE, Pet.class);
        new PetType("ElderGuardian", XMaterial.PRISMARINE_CRYSTALS, XEntityType.ELDER_GUARDIAN, PetElderGuardian.class){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Block-Effect", (Object)true, "Whether the mining fatigue effect is blocked while this pet is equipped.", "Please note that this will also block mining fatigue from real elder guardians,", "due to Spigot API limitations.");
            }
        };
        PetType.registerPet("WitherSkeleton", XMaterial.STONE_SWORD, XEntityType.WITHER_SKELETON, PetWitherSkeleton.class);
        PetType.registerPet("ZombieVillager", XMaterial.GOLDEN_APPLE, XEntityType.ZOMBIE_VILLAGER, PetZombieVillager.class);
        PetType.registerPet("Husk", XMaterial.SAND, XEntityType.HUSK, Pet.class);
        PetType.registerPet("Stray", XMaterial.ARROW, XEntityType.STRAY, PetStray.class);
        PetType.registerPet("PolarBear", XMaterial.SNOW_BLOCK, XEntityType.POLAR_BEAR, Pet.class);
        PetType.registerPet("Shulker", XMaterial.SHULKER_BOX, XEntityType.SHULKER, PetShulker.class);
        if (UltraCosmeticsData.get().getVersionManager().isUsingNMS()) {
            PetType.registerPet("Pumpling", XMaterial.PUMPKIN, XEntityType.ZOMBIE, UltraCosmeticsData.get().getVersionManager().getModule().getPumplingClass());
        }
        if ((pets = PetType.getCustomConfig(Category.PETS)) == null) {
            return;
        }
        SmartLogger log = UltraCosmeticsData.get().getPlugin().getSmartLogger();
        for (String key : pets.getKeys(false)) {
            ConfigurationSection pet = pets.getConfigurationSection(key);
            if (!(pet.isString("type") && pet.isString("item") && pet.isString("customization"))) {
                log.write(SmartLogger.LogLevel.WARNING, "Incomplete custom pet '" + key + "'");
                continue;
            }
            Optional optionalType = XEntityType.of((String)pet.getString("type").toUpperCase(Locale.ROOT));
            if (optionalType.isEmpty()) {
                log.write(SmartLogger.LogLevel.WARNING, "Invalid entity type for custom pet '" + key + "'");
                continue;
            }
            XEntityType type = (XEntityType)optionalType.get();
            if (!PET_MAP.containsKey(type)) {
                log.write(SmartLogger.LogLevel.WARNING, "Entity type '" + String.valueOf(type) + "' for pet '" + key + "' does not exist as a pet.");
                continue;
            }
            Optional mat = XMaterial.matchXMaterial((String)pet.getString("item"));
            if (mat.isEmpty() || !((XMaterial)mat.get()).get().isItem()) {
                log.write(SmartLogger.LogLevel.WARNING, "Invalid item for custom pet '" + key + "'");
                continue;
            }
            MessageManager.addMessage(Category.PETS.getConfigPath() + "." + key + ".menu-name", key);
            MessageManager.addMessage(Category.PETS.getConfigPath() + "." + key + ".entity-displayname", "<bold><playername>'s " + key);
            MessageManager.addMessage(Category.PETS.getConfigPath() + "." + key + ".Description", "A custom pet!");
            new PetType(key, (XMaterial)mat.get(), type, PET_MAP.get(type), pet.getString("customization"));
        }
    }
}

