/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.morphs.MorphAllay;
import be.isach.ultracosmetics.cosmetics.morphs.MorphAxolotl;
import be.isach.ultracosmetics.cosmetics.morphs.MorphBasic;
import be.isach.ultracosmetics.cosmetics.morphs.MorphBat;
import be.isach.ultracosmetics.cosmetics.morphs.MorphBee;
import be.isach.ultracosmetics.cosmetics.morphs.MorphBlaze;
import be.isach.ultracosmetics.cosmetics.morphs.MorphCat;
import be.isach.ultracosmetics.cosmetics.morphs.MorphCaveSpider;
import be.isach.ultracosmetics.cosmetics.morphs.MorphChicken;
import be.isach.ultracosmetics.cosmetics.morphs.MorphCod;
import be.isach.ultracosmetics.cosmetics.morphs.MorphCow;
import be.isach.ultracosmetics.cosmetics.morphs.MorphCreeper;
import be.isach.ultracosmetics.cosmetics.morphs.MorphDolphin;
import be.isach.ultracosmetics.cosmetics.morphs.MorphDonkey;
import be.isach.ultracosmetics.cosmetics.morphs.MorphDrowned;
import be.isach.ultracosmetics.cosmetics.morphs.MorphEnderman;
import be.isach.ultracosmetics.cosmetics.morphs.MorphEndermite;
import be.isach.ultracosmetics.cosmetics.morphs.MorphEvoker;
import be.isach.ultracosmetics.cosmetics.morphs.MorphFox;
import be.isach.ultracosmetics.cosmetics.morphs.MorphFrog;
import be.isach.ultracosmetics.cosmetics.morphs.MorphGlowSquid;
import be.isach.ultracosmetics.cosmetics.morphs.MorphGoat;
import be.isach.ultracosmetics.cosmetics.morphs.MorphGuardian;
import be.isach.ultracosmetics.cosmetics.morphs.MorphLlama;
import be.isach.ultracosmetics.cosmetics.morphs.MorphMooshroom;
import be.isach.ultracosmetics.cosmetics.morphs.MorphNoFall;
import be.isach.ultracosmetics.cosmetics.morphs.MorphParrot;
import be.isach.ultracosmetics.cosmetics.morphs.MorphPig;
import be.isach.ultracosmetics.cosmetics.morphs.MorphPolarBear;
import be.isach.ultracosmetics.cosmetics.morphs.MorphSheep;
import be.isach.ultracosmetics.cosmetics.morphs.MorphSlime;
import be.isach.ultracosmetics.cosmetics.morphs.MorphSniffer;
import be.isach.ultracosmetics.cosmetics.morphs.MorphSnowman;
import be.isach.ultracosmetics.cosmetics.morphs.MorphVillager;
import be.isach.ultracosmetics.cosmetics.morphs.MorphWitch;
import be.isach.ultracosmetics.cosmetics.morphs.MorphWitherSkeleton;
import be.isach.ultracosmetics.cosmetics.type.CosmeticEntType;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.version.VersionManager;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XBase;
import org.bukkit.entity.EntityType;

public class MorphType
extends CosmeticEntType<Morph> {
    private final boolean doesSkillExist;

    private MorphType(String configName, XMaterial material, XEntityType disguiseType, Class<? extends Morph> clazz, boolean doesSkillExist) {
        super(Category.MORPHS, configName, material, disguiseType, clazz);
        this.doesSkillExist = doesSkillExist;
    }

    public Component getSkill() {
        return MessageManager.getMessage(this.getConfigPath() + ".skill", new TagResolver.Single[0]);
    }

    public boolean canUseSkill() {
        return this.doesSkillExist && SettingsManager.getConfig().getBoolean(this.getConfigPath() + ".Skill-Enabled", true);
    }

    public EntityType getDisguiseType() {
        return this.getEntityType();
    }

    @Override
    public void setupConfig(CustomConfiguration config, String path) {
        super.setupConfig(config, path);
        if (this.doesSkillExist) {
            config.addDefault(path + ".Skill-Enabled", (Object)true, "Whether this morph's skill should be enabled.");
        }
        if (MorphNoFall.class.isAssignableFrom(this.getClazz())) {
            config.addDefault(path + ".No-Fall-Damage", (Object)true, "Whether to disable fall damage while this morph is equipped.", "(Normal use of the morph may cause fall damage otherwise.)");
        }
    }

    public static void registerMorph(String configName, XMaterial material, XEntityType disguiseType) {
        MorphType.registerMorph(configName, material, disguiseType, MorphBasic.class, false);
    }

    public static void registerMorph(String configName, XMaterial material, XEntityType disguiseType, Class<? extends Morph> clazz) {
        MorphType.registerMorph(configName, material, disguiseType, clazz, true);
    }

    public static void registerMorph(String configName, XMaterial material, XEntityType disguiseType, Class<? extends Morph> clazz, boolean skillEnabled) {
        if (!disguiseType.isSupported()) {
            return;
        }
        new MorphType(configName, material, disguiseType, clazz, skillEnabled);
    }

    public static void register() {
        VersionManager vm = UltraCosmeticsData.get().getVersionManager();
        MorphType.registerMorph("Bat", XMaterial.COAL, XEntityType.BAT, MorphBat.class);
        MorphType.registerMorph("Blaze", XMaterial.BLAZE_POWDER, XEntityType.BLAZE, MorphBlaze.class);
        MorphType.registerMorph("Chicken", XMaterial.EGG, XEntityType.CHICKEN, MorphChicken.class);
        MorphType.registerMorph("Pig", XMaterial.PORKCHOP, XEntityType.PIG, MorphPig.class);
        new MorphType("Enderman", XMaterial.ENDER_PEARL, XEntityType.ENDERMAN, MorphEnderman.class, true){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Mode", (Object)"Ray trace", "Changes how the enderman morph teleports.", "'Ray trace' (default) teleports a player to the block they're looking at,", "up to 16 blocks away. Doesn't perform as well as the other options.", "'Fast', teleports player 16 blocks in the direction they are looking,", "while trying to avoid suffocation. Players will be able to teleport through walls.", "'Enderpearl' simply launches an ender pearl in the direction the player is looking.");
            }
        };
        new MorphType("Slime", XMaterial.SLIME_BALL, XEntityType.SLIME, MorphSlime.class, true){

            @Override
            public void setupConfig(CustomConfiguration config, String path) {
                super.setupConfig(config, path);
                config.addDefault(path + ".Jump-Speed", (Object)2.3, "The jump speed of the slime morph ability");
            }
        };
        MorphType.registerMorph("Creeper", XMaterial.GUNPOWDER, XEntityType.CREEPER, MorphCreeper.class);
        MorphType.registerMorph("Snowman", XMaterial.SNOWBALL, XEntityType.SNOW_GOLEM, MorphSnowman.class);
        MorphType.registerMorph("Cow", XMaterial.MILK_BUCKET, XEntityType.COW, MorphCow.class);
        MorphType.registerMorph("Mooshroom", XMaterial.RED_MUSHROOM, XEntityType.MOOSHROOM, MorphMooshroom.class);
        MorphType.registerMorph("Villager", XMaterial.EMERALD, XEntityType.VILLAGER, MorphVillager.class);
        MorphType.registerMorph("Witch", XMaterial.POISONOUS_POTATO, XEntityType.WITCH, MorphWitch.class);
        MorphType.registerMorph("Sheep", XMaterial.WHITE_WOOL, XEntityType.SHEEP, MorphSheep.class);
        MorphType.registerMorph("CaveSpider", XMaterial.SPIDER_EYE, XEntityType.CAVE_SPIDER, MorphCaveSpider.class, false);
        MorphType.registerMorph("Endermite", XMaterial.ENDER_EYE, XEntityType.ENDERMITE, MorphEndermite.class, false);
        MorphType.registerMorph("Guardian", XMaterial.PRISMARINE_SHARD, XEntityType.GUARDIAN, MorphGuardian.class, false);
        MorphType.registerMorph("Wolf", XMaterial.BONE, XEntityType.WOLF);
        MorphType.registerMorph("IronGolem", XMaterial.IRON_INGOT, XEntityType.IRON_GOLEM);
        MorphType.registerMorph("Wither", XMaterial.WITHER_SKELETON_SKULL, XEntityType.WITHER);
        MorphType.registerMorph("Skeleton", XMaterial.BONE, XEntityType.SKELETON);
        MorphType.registerMorph("Zombie", XMaterial.ROTTEN_FLESH, XEntityType.ZOMBIE);
        MorphType.registerMorph("Squid", XMaterial.INK_SAC, XEntityType.SQUID);
        MorphType.registerMorph("Spider", XMaterial.STRING, XEntityType.SPIDER);
        MorphType.registerMorph("Ghast", XMaterial.GHAST_TEAR, XEntityType.GHAST);
        MorphType.registerMorph("MagmaCube", XMaterial.MAGMA_CREAM, XEntityType.MAGMA_CUBE);
        MorphType.registerMorph("Horse", XMaterial.SADDLE, XEntityType.HORSE);
        MorphType.registerMorph("Sniffer", XMaterial.SNIFFER_EGG, XEntityType.SNIFFER, MorphSniffer.class, false);
        MorphType.registerMorph("Allay", XMaterial.ALLAY_SPAWN_EGG, XEntityType.ALLAY, MorphAllay.class);
        MorphType.registerMorph("Frog", XMaterial.FROG_SPAWN_EGG, XEntityType.FROG, MorphFrog.class, false);
        MorphType.registerMorph("Warden", XMaterial.SCULK_SHRIEKER, XEntityType.WARDEN);
        MorphType.registerMorph("Tadpole", XMaterial.TADPOLE_BUCKET, XEntityType.TADPOLE);
        MorphType.registerMorph("Goat", (XMaterial)XMaterial.GOAT_HORN.or((XBase)XMaterial.WHEAT), XEntityType.GOAT, MorphGoat.class, false);
        MorphType.registerMorph("Axolotl", XMaterial.AXOLOTL_BUCKET, XEntityType.AXOLOTL, MorphAxolotl.class);
        MorphType.registerMorph("GlowSquid", XMaterial.GLOW_INK_SAC, XEntityType.GLOW_SQUID, MorphGlowSquid.class, false);
        MorphType.registerMorph("Piglin", XMaterial.GOLD_INGOT, XEntityType.PIGLIN);
        MorphType.registerMorph("Strider", XMaterial.WARPED_FUNGUS_ON_A_STICK, XEntityType.STRIDER);
        MorphType.registerMorph("Hoglin", XMaterial.COOKED_PORKCHOP, XEntityType.HOGLIN);
        MorphType.registerMorph("PiglinBrute", XMaterial.GOLDEN_AXE, XEntityType.PIGLIN_BRUTE);
        MorphType.registerMorph("Zoglin", XMaterial.ZOGLIN_SPAWN_EGG, XEntityType.ZOGLIN);
        MorphType.registerMorph("ZombifiedPiglin", XMaterial.GOLDEN_SWORD, XEntityType.ZOMBIFIED_PIGLIN);
        MorphType.registerMorph("Bee", XMaterial.HONEYCOMB, XEntityType.BEE, MorphBee.class);
        MorphType.registerMorph("Cat", XMaterial.TROPICAL_FISH, XEntityType.CAT, MorphCat.class);
        MorphType.registerMorph("Fox", XMaterial.SWEET_BERRIES, XEntityType.FOX, MorphFox.class, false);
        MorphType.registerMorph("Panda", XMaterial.BAMBOO, XEntityType.PANDA);
        MorphType.registerMorph("Ocelot", XMaterial.COD, XEntityType.OCELOT);
        MorphType.registerMorph("WanderingTrader", XMaterial.WANDERING_TRADER_SPAWN_EGG, XEntityType.WANDERING_TRADER);
        MorphType.registerMorph("Pillager", XMaterial.CROSSBOW, XEntityType.PILLAGER);
        MorphType.registerMorph("Ravager", XMaterial.RAVAGER_SPAWN_EGG, XEntityType.RAVAGER);
        MorphType.registerMorph("Cod", XMaterial.COD_BUCKET, XEntityType.COD, MorphCod.class, false);
        MorphType.registerMorph("Dolphin", XMaterial.DOLPHIN_SPAWN_EGG, XEntityType.DOLPHIN, MorphDolphin.class, false);
        MorphType.registerMorph("Drowned", XMaterial.TRIDENT, XEntityType.DROWNED, MorphDrowned.class, false);
        MorphType.registerMorph("Pufferfish", XMaterial.PUFFERFISH, XEntityType.PUFFERFISH);
        MorphType.registerMorph("Salmon", XMaterial.SALMON_BUCKET, XEntityType.SALMON);
        MorphType.registerMorph("TropicalFish", XMaterial.TROPICAL_FISH_BUCKET, XEntityType.TROPICAL_FISH);
        MorphType.registerMorph("Turtle", XMaterial.TURTLE_HELMET, XEntityType.TURTLE);
        MorphType.registerMorph("Phantom", XMaterial.PHANTOM_MEMBRANE, XEntityType.PHANTOM);
        MorphType.registerMorph("Parrot", XMaterial.COOKIE, XEntityType.PARROT, MorphParrot.class);
        MorphType.registerMorph("Illusioner", XMaterial.COMMAND_BLOCK, XEntityType.ILLUSIONER);
        MorphType.registerMorph("Llama", XMaterial.RED_WOOL, XEntityType.LLAMA, MorphLlama.class);
        MorphType.registerMorph("Evoker", XMaterial.TOTEM_OF_UNDYING, XEntityType.EVOKER, MorphEvoker.class, false);
        MorphType.registerMorph("WitherSkeleton", XMaterial.WITHER_SKELETON_SKULL, XEntityType.WITHER_SKELETON, MorphWitherSkeleton.class);
        MorphType.registerMorph("Donkey", XMaterial.CHEST, XEntityType.DONKEY, MorphDonkey.class, false);
        MorphType.registerMorph("Vex", XMaterial.IRON_SWORD, XEntityType.VEX);
        MorphType.registerMorph("Vindicator", XMaterial.IRON_AXE, XEntityType.VINDICATOR);
        MorphType.registerMorph("Mule", XMaterial.SADDLE, XEntityType.MULE);
        MorphType.registerMorph("SkeletonHorse", XMaterial.BONE_BLOCK, XEntityType.SKELETON_HORSE);
        MorphType.registerMorph("ZombieHorse", XMaterial.ZOMBIE_HORSE_SPAWN_EGG, XEntityType.ZOMBIE_HORSE);
        if (vm.isUsingNMS()) {
            MorphType.registerMorph("ElderGuardian", XMaterial.PRISMARINE_CRYSTALS, XEntityType.ELDER_GUARDIAN, UltraCosmeticsData.get().getVersionManager().getModule().getElderGuardianClass());
        }
        MorphType.registerMorph("PolarBear", XMaterial.SNOW_BLOCK, XEntityType.POLAR_BEAR, MorphPolarBear.class, vm.isUsingNMS());
        MorphType.registerMorph("Shulker", XMaterial.SHULKER_BOX, XEntityType.SHULKER);
    }
}

