/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.projectileeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.projectileeffects.ProjectileEffect;
import be.isach.ultracosmetics.cosmetics.type.ProjectileEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import org.bukkit.Location;
import org.bukkit.entity.Projectile;
import org.bukkit.util.Vector;

public class ProjectileEffectHelix
extends ProjectileEffect {
    private static final Vector Y_AXIS = new Vector(0, 1, 0);
    private static final double STEP = 0.39269908169872414;
    private double angle = 0.0;

    public ProjectileEffectHelix(UltraPlayer owner, ProjectileEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void showParticles(Projectile projectile) {
        this.angle += 0.39269908169872414;
        if (this.angle >= Math.PI * 2) {
            this.angle %= Math.PI * 2;
        }
        Vector vel = projectile.getVelocity();
        Vector particle = vel.clone().crossProduct(Y_AXIS).normalize().rotateAroundAxis(vel, this.angle);
        this.showHelix(projectile, projectile.getLocation().add(particle), projectile.getLocation().subtract(particle));
    }

    public void showHelix(Projectile projectile, Location a, Location b) {
        this.display.spawn(a);
        this.display.spawn(b);
    }
}

