/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class ParticleEffectFrozenWalk
extends ParticleEffect {
    private static final Particle ITEM_PARTICLE = XParticle.ITEM.get();

    public ParticleEffectFrozenWalk(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        Vector vectorLeft = ParticleEffectFrozenWalk.getLeftVector(this.getPlayer().getLocation()).normalize().multiply(0.15);
        Vector vectorRight = ParticleEffectFrozenWalk.getRightVector(this.getPlayer().getLocation()).normalize().multiply(0.15);
        Location locationLeft = this.getPlayer().getLocation().add(vectorLeft);
        Location locationRight = this.getPlayer().getLocation().add(vectorRight);
        locationLeft.setY(this.getPlayer().getLocation().getY());
        locationRight.setY(this.getPlayer().getLocation().getY());
        locationLeft.getWorld().spawnParticle(ITEM_PARTICLE, locationLeft, 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.SNOW.parseItem());
        locationLeft.getWorld().spawnParticle(ITEM_PARTICLE, locationRight, 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.SNOW.parseItem());
    }

    public static Vector getLeftVector(Location loc) {
        float newX = (float)(loc.getX() + 1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + 1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }

    public static Vector getRightVector(Location loc) {
        float newX = (float)(loc.getX() + -1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + -1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }
}

